import gradio as gr
import pandas as pd


def make_clickable_model(model_name, link=None):
    name = model_name.replace("https://huggingface.co/spaces/","")
    return f'<a target="_blank" href="{model_name}">{name.split("/")[-1].replace("_", " ")}</a>'

def read_df():
    df = pd.read_excel("demo_df.xlsx")
    links = []
    for i in range(df.shape[0]):
        links.append(make_clickable_model(df.iloc[i, 2]))
    df.drop(columns="Link", inplace=True)
    df.insert(2, "Link", links)
    df.insert(0, "ID", list(range(1, len(df) + 1)))
    return df

with gr.Blocks(theme=gr.themes.Soft()) as demo:
    gr.Markdown(
        """# Detomo AI Galary  🧙‍♀️ 🧛‍♀️ 🤖  """
    )
    galary = gr.Dataframe(
                    type="pandas", datatype=["number", "markdown", "markdown", "markdown"]
                )
    demo.load(read_df, inputs=None, outputs=galary)
    
demo.launch()