import pandas as pd
import PIL
from PIL import Image
from PIL import ImageDraw
import gradio as gr
import torch
import easyocr
import cv2 as cv
import math
from numpy import asarray
import numpy as np

torch.hub.download_url_to_file('https://i.pinimg.com/736x/93/d3/54/93d354497ea26d5dc181055b9356cf79.jpg', 'korean.jpg')
torch.hub.download_url_to_file('https://64.media.tumblr.com/1a5796817934a179664508693cae82d3/67c2ea7948c385cc-1b/s1280x1920/a70d4fcc0a5528de415b024db4ee6036da9c4c35.jpg', 'chinese.jpg')
torch.hub.download_url_to_file('https://jtalkonline.com/wp-content/uploads/2014/06/ichigo-bleach-manga-japanese.jpg', 'japanese.jpg')
torch.hub.download_url_to_file('https://img.mghubcdn.com/file/imghub/moriarty-the-patriot/68/10.jpg', 'english.jpg')
    
def midpoint(x1, y1, x2, y2):
    x_mid = int((x1 + x2)/2)
    y_mid = int((y1 + y2)/2)
    return (x_mid, y_mid)

def draw_boxes(img, bounds, color='yellow', width=2):
    mask = np.zeros((img.shape[:2]), dtype="uint8")
    for bound in bounds:
        pts = np.array([bound[0]], np.int32)
        cv.fillPoly(mask, pts, color =(255,255,255))
    img = cv.inpaint(img, mask, 3, cv.INPAINT_NS)       
    return(img)
       
def inference(img, lang):
    if lang == "english":
        lang = ['en']
    elif lang == "chinese":
        lang = ['ch_sim']
    elif lang == "korean":
        lang = ['ko']
    else:
        lang = ['ja']
    reader = easyocr.Reader(lang)
    bounds = reader.readtext(img.name)
    im = PIL.Image.open(img.name)
    img_array = np.array(im)
    img = draw_boxes(img_array, bounds)
    img = Image.fromarray(img, 'RGB')
    lang = ""
    img.save('box.jpg')
    
    return ['box.jpg', pd.DataFrame(bounds). iloc[: , 1:2]]

title = 'Manga Image Cleaner'
description = 'Image inpainting and text detection demo with the use of EasyOCR and CV2. To use it, simply upload your image and choose a language from the dropdown menu, or click one of the examples to test the program.'
article = "<p style='text-align: center'> <a>Ready-to-use image inpainting with supported languages such as: Chinese, English, Japanese, and Korean</a> | <a href='https://github.com/JaidedAI/EasyOCR'>Github OCR Repo</a> | <a href='https://towardsdatascience.com/remove-text-from-images-using-cv2-and-keras-ocr-24e7612ae4f4'>CV2 Reference</a></p>"
css = ".output_image, .input_image {height: 40rem !important; width: 100% !important;}"
examples = [['chinese.jpg',"chinese"], ['english.jpg',"english"], ['japanese.jpg',"japanese"], ['korean.jpg',"korean"]]
choices = [
    "chinese",
    "english",
    "japanese",
    "korean"
]
gr.Interface(
    inference,
    [gr.inputs.Image(type='file', label='Input'),gr.inputs.Dropdown(choices, type="value", default="korean", label='language')],
    [gr.outputs.Image(type='file', label='Output'),  
    gr.outputs.Dataframe()],
    title=title,
    description=description,
    article=article,
    examples=examples,
    css=css,
    enable_queue=True
    ).launch(debug=True)