import gradio as gr
from PIL import Image
import requests
from io import BytesIO

# The image processing function
def process_image(image_url: str) -> Image.Image:
    # Download the image from the provided URL
    response = requests.get(image_url)
    image = Image.open(BytesIO(response.content))

    # Get the dimensions of the image
    width, height = image.size
    max_size = 2000

    # Calculate the new dimensions while preserving the aspect ratio
    if width > height:
        new_width = max_size
        new_height = int(max_size * height / width)
    else:
        new_height = max_size
        new_width = int(max_size * width / height)

    # Create a new transparent canvas with the max_size dimensions
    canvas = Image.new('RGBA', (max_size, max_size), (0, 0, 0, 0))

    # Calculate the position offsets for centering the resized image
    x_offset = (max_size - new_width) // 2
    y_offset = (max_size - new_height) // 2

    # Paste the resized image onto the canvas
    canvas.paste(image.resize((new_width, new_height)), (x_offset, y_offset))

    return canvas

iface = gr.Interface(
    fn=process_image,
    inputs=gr.inputs.Textbox(lines=1, placeholder='Enter image URL here...'),
    outputs='image',
    title="Image Processing",
    description="Enter an image URL and the image will be fitted into a 1000x1000 square canvas while preserving the original aspect ratio.",
)

iface.launch()