import gradio as gr
from icon_automation_copy import update_related_opportunities_icons

# Defining the interface function
def interface(notion_url, image_url):
    # Calling the update_related_opportunities_icons function with the provided URLs
    update_related_opportunities_icons(notion_url, image_url)
    return "Operation Completed"

# Creating an instance of the gr.Interface class
iface = gr.Interface(
    # Setting the interface function as the function to be called when inputs are provided
    fn=interface,
    # Defining the inputs for the interface as two text boxes: Notion URL and Image URL
    inputs=[
        gr.inputs.Textbox(label="Notion URL"),
        gr.inputs.Textbox(label="Image URL"),
    ],
    # Setting the output of the interface as a single text box
    outputs=gr.outputs.Textbox(),
    # Setting the title and description of the interface
    title="Icon Automation for Notion",
    description="Enter the Notion URL of the organization page and the image URL you want to set as the icon. This will update the icons of all related opportunities.",
)

# Launching the interface, making it accessible for user interaction
iface.launch()