import requests

# Set Notion API token and database ID
NOTION_TOKEN = "secret_Kg8afS2dttLpGvuQ07pbmrJorjl3krgzubpll0iVCv9"
DATABASE_ID = "b617878a8f284379a916ba6f2200654f"

# Set headers for Notion API requests
headers = {
    "Authorization": "Bearer " + NOTION_TOKEN,
    "Notion-Version": "2022-06-28",
    "content-type": "application/json"
}


def get_organization_page(notion_url):
    """
    Query the Notion database for the organization page with the specified URL.

    :param notion_url: The URL of the organization page in the Notion database.
    :return: The organization page object if found, otherwise None.
    """

    # Construct the API endpoint URL using the global constant DATABASE_ID
    url = f"https://api.notion.com/v1/databases/{DATABASE_ID}/query"

    # Define the query filter for the Notion API request
    data = {
        "filter": {
            "property": "URL",
            "url": {
                "equals": notion_url
            }
        }
    }

    # Send a POST request to the Notion API with the constructed URL, query filter, and headers
    response = requests.post(url, json=data, headers=headers)
    response_json = response.json()

    # # Print the API response for debugging purposes
    print("API response:", response_json)

    results = response_json["results"]

    # Return the first organization page object in the results array, or None if there are no results
    if len(results) > 0:
        return results[0]
    else:
        return None


def update_opportunity_icon(opportunity_page_id, image_url):
    """
    Update the icon of a specific opportunity page with an image URL.

    :param opportunity_page_id: The ID of the opportunity page in the Notion database.
    :param image_url: The URL of the new image to be set as the icon.
    :return: True if the update was successful, False otherwise.
    """

    # Set the URL of the Notion API endpoint for updating the page with the given ID
    url = f"https://api.notion.com/v1/pages/{opportunity_page_id}"

    # Define the data to be sent in the request body, including the new image URL
    data = {
        "icon": {
            "type": "external",
            "external": {
                "url": image_url
            }
        }
    }

    # Send a PATCH request to the Notion API to update the page with the new image URL
    response = requests.patch(url, json=data, headers=headers)

    # Return True if the response status code indicates success, False otherwise
    return response.status_code == 200


def update_related_opportunities_icons(notion_url, image_url):
    """
    Update the icons of all opportunities related to an organization page.

    :param notion_url: The URL of the organization page in the Notion database.
    :param image_url: The URL of the new image to be set as the icon.
    """

    # Get the organization page object from the Notion database using the URL
    organization_page = get_organization_page(notion_url)

    # If the organization page is found
    if organization_page:
        # Extract the list of related opportunities from the page object
        related_opportunities = organization_page["properties"]["Related opportunities"]["relation"]

        # For each related opportunity
        for opportunity in related_opportunities:
            # Get the opportunity page ID
            opportunity_page_id = opportunity["id"]

            # Try to update the opportunity icon with the new image URL using the update_opportunity_icon() function
            if update_opportunity_icon(opportunity_page_id, image_url):
                print(f"Updated icon for opportunity page: {opportunity_page_id}")
            else:
                print(f"Failed to update icon for opportunity page: {opportunity_page_id}")
    else:
        print("Organization page not found.")
