#python3
#build a text summarizer using hugging face and gradio 
#https://pypi.org/project/gradio/
#https://huggingface.co/transformers/
import gradio as gr
import transformers
from transformers import pipeline
summarizer = pipeline("summarization")
def summarize(text):
    return summarizer(text, max_length=200, min_length=30)[0]['summary_text']
gr.Interface(fn=summarize, inputs=gr.inputs.Textbox(lines=7, placeholder="Enter text here"), outputs="text",
    examples=[["The Higgs boson is an elementary particle in the Standard Model of particle physics produced by the quantum excitation of the Higgs field,one of the fields in particle physics theory.In the Standard Model, the Higgs particle is a massive scalar boson with zero spin, no electric charge, and no colour charge. It is also very unstable, decaying into other particles almost immediately.It is named after physicist Peter Higgs, who in 1964 along with five other scientists proposed the Higgs mechanism to explain why some particles have mass. (Particles acquire mass in several ways, but a full explanation for all particles had been extremely difficult.) This mechanism required that a spinless particle known as a scalar boson should exist with properties as described by the Higgs Mechanism theory. This particle was called the Higgs boson.In 2012, a subatomic particle with the expected properties was discovered by the ATLAS and CMS experiments at the Large Hadron Collider (LHC) at CERN near Geneva, Switzerland. The new particle was subsequently confirmed to match the expected properties of a Higgs boson."
],
["In mathematics and physics, the heat equation is a certain partial differential equation. Solutions of the heat equation are sometimes known as caloric functions. The theory of the heat equation was first developed by Joseph Fourier in 1822 for the purpose of modeling how a quantity such as heat diffuses through a given region.As the prototypical parabolic partial differential equation, the heat equation is among the most widely studied topics in pure mathematics, and its analysis is regarded as fundamental to the broader field of partial differential equations. The heat equation can also be considered on Riemannian manifolds, leading to many geometric applications. Following work of Subbaramiah Minakshisundaram and Åke Pleijel, the heat equation is closely related with spectral geometry. A seminal nonlinear variant of the heat equation was introduced to differential geometry by James Eells and Joseph Sampson in 1964, inspiring the introduction of the Ricci flow by Richard Hamilton in 1982 and culminating in the proof of the Poincaré conjecture by Grigori Perelman in 2003. Certain solutions of the heat equation known as heat kernels provide subtle information about the region on which they are defined, as exemplified through their application to the Atiyah–Singer index theorem."],
["Genghis Khan (c. 1158 – August 18, 1227), born Temüjin,was the founder and first Great Khan (Emperor) of the Mongol Empire, which became the largest contiguous empire in history after his death. He came to power by uniting many of the nomadic tribes of Northeast Asia, and, after being proclaimed the universal ruler of the Mongols, or Genghis Khan, he launched the Mongol invasions, which ultimately conquered most of Eurasia, reaching as far west as Poland and as far south as Egypt. His major campaigns include those against the Qara Khitai, Khwarezmia, and the Western Xia and Jin dynasties, and raids into medieval Georgia, the Kievan Rus', and Volga Bulgaria.Genghis Khan and his empire have a fearsome reputation in local histories.Many medieval chroniclers and modern historians describe Genghis Khan's conquests as wholesale destruction on an unprecedented scale, causing great demographic changes and a drastic decline of population as a result of mass exterminations and famine. A conservative estimate amounts to about four million civilians (whereas other figures range from forty to sixty million) who lost their lives as a consequence of Genghis Khan's military campaigns.In contrast, Buddhist Uyghurs of the kingdom of Qocho, who willingly left the Qara Khitai empire to become Mongol vassals, viewed him as a liberator. Genghis Khan was also portrayed positively by early Renaissance sources out of respect for the great spread of culture, technology and ideas under the Mongol Empire.[14] By the end of the Great Khan's life, the Mongol Empire occupied a substantial portion of Central Asia and China. Due to his exceptional military successes, Genghis Khan is often considered to be one of the greatest conquerors of all time."
]]).launch(inline = False)