import gradio as gr
from spacy import displacy
from transformers import pipeline
from transformers import AutoTokenizer
from transformers import AutoModelForSequenceClassification


tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model_name_or_path = "DelinteNicolas/SDG_classifier_v0.0.4"
model = AutoModelForSequenceClassification.from_pretrained(
    model_name_or_path)
classifier = pipeline("text-classification",
                      model=model, tokenizer=tokenizer)


def predict(text, thresh, model_name):

    colors = {"SDG1: No Poverty": "#e16f78",
              "SDG10: Reduced Inequality": "#e26cac",
              "SDG11: Sustainable Cities and Communities": "#e5b270",
              "SDG12: Responsible Consumption and Production": "#e3b36b",
              "SDG13: Climate Action": "#86df73",
              "SDG14: Life Below Water": "#6fbce2",
              "SDG15: Life on Land": "#70e47b",
              "SDG16: Peace and Justice Strong Institutions": "#68aedc",
              "SDG17: Partnerships to achieve the Goal": "#7099de",
              "SDG2: Zero Hunger": "#e6c67b",
              "SDG3: Good Health and Well-being": "#72dd91",
              "SDG4: Quality Education": "#e1707d",
              "SDG5: Gender Equality": "#e17669",
              "SDG6: Clean Water and Sanitation": "#78cce1",
              "SDG7: Affordable and Clean Energy": "#e2bf6e",
              "SDG8: Decent Work and Economic Growth": "#e07391",
              "SDG9: Industry, Innovation and Infrastructure": "#e49971"}

    doc = {
        "text": text,
        "ents": [],
        "colors": colors,
        "title": None
    }

    txtList = text.split('.')
    sdg = classifier(txtList)

    for i, txt in enumerate(txtList):

        if sdg[i]['score'] > thresh and len(txt) > 10 and sdg[i]['label'] != 'Not a SDG':
            doc["ents"].append({"start": text.index(txt), "end": text.index(
                txt)+len(txt)+1, "label": sdg[i]['label']})

    html = displacy.render(doc, style="ent", page=True,
                           manual=True, minify=True, options={"colors": colors})
    html = (
        "<div style='overflow:auto'>"
        + html
        + "</div>"
    )

    return html


iface = gr.Interface(
    fn=predict,
    inputs=[
        gr.inputs.Textbox(
            lines=10,
            default="World hunger will be solved by 2030.",
            label="Input Text"),
        gr.Slider(0, 1, value=.9, interactive=True, label="Confidence"),
        gr.Dropdown(["SDG_classifier_v0.0.1",
                     "SDG_classifier_v0.0.2",
                     "SDG_classifier_v0.0.3",
                     "SDG_classifier_v0.0.4",
                     "SDG_classifier_v0.0.5"],
                    value="SDG_classifier_v0.0.4",
                    label="Classification Model")],
    outputs="html",
)
iface.launch()
