import streamlit as st
from PIL import Image
import io
import os

# Set the title and a short description for your app
st.title("Image Processing App")
st.write("Upload an image, resize it, convert it to black and white, and download the processed image.")

# Create a file uploader widget
uploaded_image = st.file_uploader("Upload an image", type=["jpg", "jpeg", "png"])

# Create a slider widget to choose the resize width
resize_width = st.slider("Choose the resize width (in pixels):", 1, 1000, 300)

# Create a checkbox for converting to black and white
convert_to_bw = st.checkbox("Convert to Black and White")

if uploaded_image is not None:
    # Display the uploaded image
    st.image(uploaded_image, caption="Uploaded Image", use_column_width=True)

    # Open the uploaded image
    image = Image.open(uploaded_image)

    # Resize the image if requested
    if resize_width:
        image = image.resize((resize_width, int(resize_width * image.height / image.width)))

    # Convert the image to black and white if requested
    if convert_to_bw:
        image = image.convert("L")

    # Display the processed image
    st.image(image, caption="Processed Image", use_column_width=True)

    # Create a download button to download the processed image
    download_button = st.button("Download Processed Image")

    if download_button:
        # Save the processed image to a temporary file
        with io.BytesIO() as output:
            image.save(output, format="JPEG")
            processed_image_data = output.getvalue()

        # Provide a download link for the processed image
        st.download_button(
            label="Download Processed Image",
            data=processed_image_data,
            file_name="processed_image.jpg",
        )
