
from tensorflow import keras
import gradio as gr
model = keras.models.load_model('NSFW2.h5')
class_names = ['normal', 'porn']

def predict_input_image(img):
  img_4d=img.reshape(-1,224,224,3)
  prediction=model.predict(img_4d)[0]
  return {class_names[i]: float(prediction[i]) for i in range(len(class_names))}


image = gr.inputs.Image(shape=(224,224))
label = gr.outputs.Label(num_top_classes=1)

gr.Interface(fn=predict_input_image, inputs=image, outputs=label,interpretation='default').launch(debug='True')


