from tensorflow import keras
import gradio as gr
model = keras.models.load_model('Bottle_images.h5')
class_names = ['Beer Bottles','Plastic Bottles','Soda Bottle','Water Bottle','Wine Bottle']

def predict_input_image(img):
  img_4d=img.reshape(-1,120,120,3)
  prediction=model.predict(img_4d)[0]
  return {class_names[i]: float(prediction[i]) for i in range(len(class_names))}


image = gr.inputs.Image(shape=(120,120))
label = gr.outputs.Label(num_top_classes=len(class_names))

gr.Interface(fn=predict_input_image, inputs=image, outputs=label,interpretation='default').launch(debug='True')
