import gradio as gr

##############################
def gradio_inputs_for_MD_DLC(md_models_list, # list(MD_models_dict.keys())
                             dlc_models_list, # list(DLC_models_dict.keys())
                             ):
    # Input image
    gr_image_input = gr.inputs.Image(type="pil", label="Input Image")


    # Models
    gr_mega_model_input = gr.inputs.Dropdown(choices=md_models_list,
                                            default='md_v5a', # default option
                                            type='value', # Type of value to be returned by component. "value" returns the string of the choice selected, "index" returns the index of the choice selected.
                                            label='Select Detector model')
    gr_dlc_model_input = gr.inputs.Dropdown(choices=dlc_models_list, # choices
                                            default='superanimal_quadruped', # default option
                                            type='value', # Type of value to be returned by component. "value" returns the string of the choice selected, "index" returns the index of the choice selected.
                                            label='Select DeepLabCut model')                                                                     
    
    # Other inputs
    gr_dlc_only_checkbox = gr.inputs.Checkbox(False,
                                            label='Run DLClive only, directly on input image?')                                        
    gr_str_labels_checkbox = gr.inputs.Checkbox(True,
                                                label='Show bodypart labels?')   

    gr_slider_conf_bboxes = gr.inputs.Slider(0,1,.05,0.2,
                                            label='Set confidence threshold for animal detections')
    gr_slider_conf_keypoints = gr.inputs.Slider(0,1,.05,0.4,
                                                label='Set confidence threshold for keypoints')

    # Data viz                                            
    gr_keypt_color = gr.ColorPicker(value ="#862db7", label="choose color for keypoint label") 

    gr_labels_font_style = gr.inputs.Dropdown(choices=['amiko', 'animals', 'nature', 'painter', 'zen'],
                                            default='amiko',
                                            type='value', 
                                            label='Select keypoint label font')
    gr_slider_font_size = gr.inputs.Slider(5,30,1,8,
                                          label='Set font size')
    gr_slider_marker_size = gr.inputs.Slider(1,20,1,9,
                                            label='Set marker size')   

    # list of inputs
    return [gr_image_input,
            gr_mega_model_input,
            gr_dlc_model_input,
            gr_dlc_only_checkbox,
            gr_str_labels_checkbox,
            gr_slider_conf_bboxes,
            gr_slider_conf_keypoints,
            gr_labels_font_style,
            gr_slider_font_size, 
            gr_keypt_color,
            gr_slider_marker_size]     

####################################################
def gradio_outputs_for_MD_DLC():
    # User interface: outputs
    gr_image_output = gr.outputs.Image(type="pil", label="Output Image")
    gr_file_download = gr.File(label="Download JSON file")
    return [gr_image_output,
            gr_file_download]

##############################################
# User interace: description
def gradio_description_and_examples():
    title = "DeepLabCut Model Zoo SuperAnimals"
    description = "Test the SuperAnimal models from the <a href='http://www.mackenziemathislab.org/dlc-modelzoo'>DeepLabCut ModelZoo Project</a>\, and read more on arXiv: https://arxiv.org/abs/2203.07436! Simply upload an image and see how it does. Want to run on videos on the cloud or locally? See the <a href='http://www.mackenziemathislab.org/dlc-modelzoo'>DeepLabCut ModelZoo</a>\."


    examples = [['examples/dog.jpeg', 'md_v5a', 'superanimal_quadruped', False, True, 0.5, 0.00, 'amiko',9, 'red', 3]]

    return [title,description,examples]