# Set the source directory
SOURCE_DIR="/Volumes/NVMe 4/Proj_YOLO/Dataset/Hugging_Face_Remote/COCO/train2017"

# Count the number of files
NUM_FILES=$(ls -1q "$SOURCE_DIR" | wc -l)

# Calculate how many files per directory
FILES_PER_DIR=$(( NUM_FILES / 12 ))

# Split files across the 12 directories
for i in {1..12}; do
    # Create the directory
    mkdir -p "${SOURCE_DIR}_$i"

    # Move a subset of files to the new directory
    find "$SOURCE_DIR" -maxdepth 1 -type f | head -n $FILES_PER_DIR | xargs -I {} mv {} "${SOURCE_DIR}_$i"

    echo "Moved files to ${SOURCE_DIR}_$i"
done

