import os
import chainlit as cl
from langchain.llms import OpenAI

# The OPENAI_API_KEY is a secret in huggingface settings.
# this is the way to retrieve it in runtime
OPENAI_API_KEY = os.environ.get("OPENAI_API_KEY")

# when the user starts a chat, this will be called
@cl.on_chat_start
async def start():
    # Your logic will be here
    # content = "The function start() is called when the user starts a chat because of the decorator @cl.on_chat_start"
    # await cl.Message(content=content).send()

    # ask the user for their OpenAI API key
    # OPENAI_API_KEY = await cl.AskUserMessage(
    #     content="Please enter your OpenAI API key", timeout=100
    # ).send()['content']

    # Chainlit will automatically load environment variables from a .env file in the root of the project
    # so you can just get the API key using cl.user_session.get("OPENAI_API_KEY")
    # OPENAI_API_KEY = cl.user_session.get("OPENAI_API_KEY")


    # define the model and save it as an environment variable so that it can be used later
    llm = OpenAI(
        model_name="gpt-3.5-turbo",
        temperature=0,
        max_tokens=2000,
        openai_api_key=OPENAI_API_KEY,
    )
    cl.user_session.set(key="llm", value=llm)


# continously on a loop
# the @on_message decorator to tell Chainlit to run the main function each time a user sends a message. Then, we send back the answer to the UI with the Message class.
@cl.on_message
async def main(message: str):
    # Your logic will be here
    llm = cl.user_session.get("llm")
    result = llm(message)
    # send a response back to the user all the time
    await cl.Message(content=f"The answer from gpt-3.5-turbo: \n{result}").send()
