from src.summarizer import Summarizer
import gradio as gr

def inference(document):
    summarizer = Summarizer("sshleifer/distill-pegasus-cnn-16-4")
    slide_content = summarizer.extract_text(document)
    summarized_slides = summarizer(slide_content)
    markdown = summarizer.convert2markdown(summarized_slides)
    summarizer.remove_leading_empty_lines(markdown.file_name)
    return markdown.file_name

with gr.Blocks() as demo:
    inp = gr.File(file_types=['pdf'])
    out = gr.File(label="Markdown File")
    inference_btn = gr.Button("Summarized PDF")
    inference_btn.click(fn=inference, inputs=inp, outputs=out, show_progress=True, api_name="summarize")
    
demo.launch()