from turtle import title
import gradio as gr
from transformers import pipeline
import numpy as np
from PIL import Image


pipe = pipeline("zero-shot-image-classification", model="openai/clip-vit-base-patch32")
images="dog.jpg"

def shot(image, labels_text):
    PIL_image = Image.fromarray(np.uint8(image)).convert('RGB')
    labels = labels_text.split(",")
    res = pipe(images=PIL_image, 
           candidate_labels=labels,
           hypothesis_template= "This is a photo of a {}")
    return {dic["label"]: dic["score"] for dic in res}
    
iface = gr.Interface(shot, 
                    ["image", "text"], 
                    "label", 
                    examples=[["dog.jpg", "dog,cat,bird"], 
                              ["germany.jpg", "germany,belgium,colombia"],
                              ["colombia.jpg", "germany,belgium,colombia"]],
                    description="Add a picture and a list of labels separated by commas",
                    title="Zero-shot Image Classification")

iface.launch()