import pandas as pd
from joblib import dump, load
import gradio as gr

rfc = load('wine_pred.joblib') 

def predict_quality(fixed_acidity, volatile_acidity, citric_acid, residual_sugar, chlorides, free_sulfur_dioxide, total_sulfur_dioxide, density, ph, sulphates, alcohol):
    df = pd.DataFrame.from_dict(
        {
            'fixed acidity': fixed_acidity,
            'volatile acidity': volatile_acidity,
            'citric acid': citric_acid,
            'residual sugar': residual_sugar,
            'chlorides': chlorides,
            'free sulfur dioxide': free_sulfur_dioxide,
            'total sulfur dioxide': total_sulfur_dioxide,
            'density': density,
            'pH': ph,
            'sulphates': sulphates,
            'alcohol': alcohol
        }, orient='index').T
        
    return rfc.predict(df)[0]



iface = gr.Interface(
    predict_quality,
    [
        gr.inputs.Slider(0, 20),
        gr.inputs.Slider(0, 2),
        gr.inputs.Slider(0, 1),
        gr.inputs.Slider(0, 20),
        gr.inputs.Slider(0, 1),
        gr.inputs.Slider(0, 100),
        gr.inputs.Slider(0, 300),
        gr.inputs.Slider(0, 2),
        gr.inputs.Slider(0, 5),
        gr.inputs.Slider(0, 2),
        gr.inputs.Slider(0, 15)

    ],
    "label",
    examples=[
        [7.4, 0.7, 0.0, 1.9, 0.076, 11.0, 34.0, 0.9978, 3.51, 0.56, 9.4],
    ],
    interpretation="default",
    title="Wine quality regressor",
    description="Predict wine quality based on properties"
)

if __name__ == "__main__":
    iface.launch()