from pysentimiento import create_analyzer


import gradio as gr

analyzer = create_analyzer(task="sentiment", lang="es")

def sentiment_analysis(text):
    
    sent = analyzer.predict(text).probas
    return sent

iface = gr.Interface(sentiment_analysis, 
                    "textbox", 
                    "label", 
                    interpretation="default",
                    title="Spanish Sentiment Analysis",
                    description="Write a sentence in spanish to analyze its sentiment")

iface.test_launch()
if __name__ == "__main__":
    iface.launch()