import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import gradio as gr
#import joblib
from sklearn.linear_model import LinearRegression
from sklearn.tree import DecisionTreeRegressor
from sklearn.ensemble import RandomForestRegressor
from sklearn.model_selection import StratifiedShuffleSplit
from sklearn.impute import SimpleImputer
from sklearn.pipeline import Pipeline
from sklearn.compose import ColumnTransformer
from sklearn.preprocessing import StandardScaler
from sklearn.preprocessing import OneHotEncoder
from sklearn.metrics import mean_squared_error
from sklearn.model_selection import cross_val_score
from sklearn.model_selection import RandomizedSearchCV
from sklearn.preprocessing import MinMaxScaler 
from sklearn.model_selection import train_test_split

df = pd.read_csv('Housing.csv')
cat_columns = ['mainroad',
       'guestroom', 'basement', 'hotwaterheating', 'airconditioning',
        'prefarea']

def binary_mapping(x):
  return x.map({'yes': 1, "no": 0})

df[cat_columns] = df[cat_columns].apply(binary_mapping)


ohe = OneHotEncoder(sparse=False, handle_unknown='error', drop='first')
ohe_df = pd.DataFrame(ohe.fit_transform(df[['furnishingstatus']]))

ohe_df.columns = ohe.get_feature_names(['status'])

df = pd.concat([df,ohe_df], axis=1)
df.drop(['furnishingstatus'], axis = 1, inplace = True)
df.head()



df_new = df.copy(deep=True)
num_columns = ['area', 'bedrooms', 'bathrooms', 'stories','parking']



scaler = MinMaxScaler().fit(df_new[num_columns])
df_new[num_columns] = scaler.transform(df_new[num_columns])
y = df_new.pop('price')
x = df_new
x_train, x_test, y_train, y_test = train_test_split(x, y, test_size=0.25, random_state=42)
model = RandomForestRegressor()
model.fit(x_train, y_train)

def prediction(properties):
    print(properties)
    df = pd.DataFrame(properties, columns=x_test.columns)
    print(df)
    df = df[x_test.columns].iloc[0].to_frame().T
    df[num_columns] = scaler.transform(df[num_columns])
    return model.predict(df)
example = pd.DataFrame([7420, 4, 2, 3, 1, 0, 0, 0, 1, 2, 1, 0, 0]).T
example.columns = x_test.columns

demo = gr.Interface(
    prediction,
    [
        gr.Dataframe(
            headers=['area', 'bedrooms', 'bathrooms', 'stories', 'mainroad', 'guestroom',
                      'basement', 'hotwaterheating', 'airconditioning', 'parking', 'prefarea',
                      'status_semi-furnished', 'status_unfurnished'],
            datatype=["number", "number", "number", "number", "number", "number", "number", "number", "number", "number", "number", "number", "number"],
        )
        
    ],
    "number",
    description="Enter The Properties Of The Home",
    title="California Housing Prices Prediction",
    examples=[example],
    

)

demo.launch()
