import streamlit as st
import openai
from reportlab.lib.pagesizes import letter
from reportlab.pdfgen import canvas

# Set OpenAI API credentials
openai.api_key = "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"

# Add custom CSS styles
st.markdown(
    """
    <style>
    body {
        background-color: black;
        color: purple;
    }

    /* Modify the color of the title */
    .css-1fcmnw0 h1 {
        color: purple;
    }

    /* Modify the background color of the input field */
    .css-xpo4mk.st-cg {
        background-color: #483d8b;
        color: white;
    }

    /* Modify the color of the dropdown select box */
    .css-2trqyj {
        color: purple;
    }

    /* Modify the background and text color of the button */
    .css-14jx6h6 {
        background-color: purple;
        color: white;
    }
    </style>
    """,
    unsafe_allow_html=True
)

# Set page title
st.title("A.I Lesson Plan for Teachers")

# Ask for age
age = st.number_input("Enter your age", min_value=0, max_value=100, step=1)

# Ask for subject and provide a text area
subject = st.text_area("Enter the subject")
board = st.text_area("Enter the board ex: edexcel, aqa, IB or CBSE")

# Complexity levels
complexity_levels = ["Beginner", "Intermediate", "Advanced", "Expert", "Master"]
complexity = st.selectbox("Select the complexity level", complexity_levels)

# Number of days
plan_duration = st.selectbox("Select the duration of the plan", ["1 hour", "1 week", "1 month", "3 months","6 months"])

# Generate lesson plan
if st.button("Generate Lesson Plan"):
    # Define the prompt for ChatGPT
    prompt = f"Generate a detailed lesson plan along with a few topic examples for teaching {subject} to {age}-year-old students. The lesson plan should have a complexity level of {complexity} and a duration of {plan_duration}.The lesson plan should follow the {board} exam board."

    # Call the OpenAI API to generate the lesson plan
    response = openai.Completion.create(
        engine="text-davinci-003",
        prompt=prompt,
        max_tokens=1000,
        n=1,
        stop=None,
        temperature=0.7
    )

    # Extract the generated lesson plan from the API response
    lesson_plan = response.choices[0].text.strip()

    # Display the generated lesson plan
    st.subheader("Generated Lesson Plan")
    st.write(lesson_plan)

    # Create PDF file
    def create_pdf():
        pdf_file = "lesson_plan.pdf"
        c = canvas.Canvas(pdf_file, pagesize=letter)
        c.setFillColor("#000000")  # Set fill color to black
        c.setFont("Helvetica", 12)
        c.drawString(100, 700, "Lesson Plan:")
        c.setFont("Helvetica", 10)
        lines = lesson_plan.split("\n")
        y = 680
        for line in lines:
            c.drawString(100, y, line)
            y -= 15
        c.save()
        return pdf_file

    # Download button for the lesson plan in PDF format
    pdf_file = create_pdf()
    st.download_button(
        label="Download Lesson Plan (PDF)",
        data=pdf_file,
        file_name="lesson_plan.pdf",
        mime="application/pdf"
    )
