import streamlit as st
import numpy as np
import plotly.express as px
import pandas as pd
import plotly.graph_objects as go

st.set_page_config(page_title="Plotly Graphing Libraries",layout='wide')

# https://plotly.com/python/treemaps/

df = px.data.tips()
fig = px.treemap(df, path=[px.Constant("all"), 'sex', 'day', 'time'], 
                 values='total_bill', color='time',
                  color_discrete_map={'(?)':'lightgrey', 'Lunch':'gold', 'Dinner':'darkblue'})
fig.update_layout(margin = dict(t=50, l=25, r=25, b=25))
#fig.show()
fig.update_traces(marker=dict(cornerradius=5))

st.plotly_chart(fig, use_container_width=True)


df = px.data.gapminder().query("year == 2007")
fig = px.treemap(df, path=[px.Constant("world"), 'continent', 'country'], values='pop',
                  color='lifeExp', hover_data=['iso_alpha'],
                  color_continuous_scale='RdBu',
                  color_continuous_midpoint=np.average(df['lifeExp'], weights=df['pop']))
fig.update_layout(margin = dict(t=50, l=25, r=25, b=25))
#fig.show()
st.plotly_chart(fig, use_container_width=True)


df = pd.read_csv('https://raw.githubusercontent.com/plotly/datasets/96c0bd/sunburst-coffee-flavors-complete.csv')
fig = go.Figure(go.Treemap(
    ids = df.ids,
    labels = df.labels,
    parents = df.parents,
    pathbar_textfont_size=15,
    root_color="lightgrey"
))
fig.update_layout(
    uniformtext=dict(minsize=10, mode='hide'),
    margin = dict(t=50, l=25, r=25, b=25)
)
#fig.show()
st.plotly_chart(fig, use_container_width=True)


df = pd.read_pickle('bloom_dataset.pkl')
fig = px.treemap(df, path=[px.Constant("ROOTS"), 'Macroarea', 'Family', 'Genus', 'Language', 'dataset_name'],
                 values='num_bytes', maxdepth=4)
fig.update_traces(root_color="pink")
fig.update_layout(margin = dict(t=50, l=25, r=25, b=25))

st.plotly_chart(fig, use_container_width=True)


