# Import necessary libraries
import streamlit as st
import pandas as pd
from pmdarima import auto_arima
import matplotlib.pyplot as plt

# Title of the Streamlit app
st.title('Auto ARIMA Time Series Analysis')

# Upload CSV data
uploaded_file = st.file_uploader("Choose a CSV file", type='csv')

if uploaded_file is not None:
    # Read the uploaded CSV file with pandas
    df = pd.read_csv(uploaded_file)

    # Convert timestamp column to datetime format and set it as index 
    df['timestamp'] = pd.to_datetime(df['timestamp'])
    df.set_index('timestamp', inplace=True)

    # Perform Auto ARIMA analysis on value column
    model = auto_arima(df['value'], trace=True, error_action='ignore', suppress_warnings=True)
    
    # Fit the model and get predictions for next 10 periods 
    model.fit(df['value'])
    predictions = model.predict(n_periods=10)
    
    # Display model summary in Streamlit app 
    st.write(model.summary())

    # Create a plot with Matplotlib and display it in Streamlit app 
    fig, ax = plt.subplots()
    
    ax.plot(df.index, df['value'], label='Original')
    
    prediction_index = pd.date_range(start=df.index[-1], periods=11)[1:]
    
    ax.plot(prediction_index, predictions, label='Predicted')
    
    plt.title('Value vs Timestamp')
    
    plt.legend()
    
    st.pyplot(fig)

    # Create a plot with Matplotlib and display it in Streamlit app 
    fig2, ax2 = plt.subplots()
    
    ax2.plot(df.index, df['value'], label='Original')
    
    prediction_index = pd.date_range(start=df.index[-1], periods=11)[1:]
    
    # ax2.plot(prediction_index, predictions, label='Predicted')
    
    plt.title('Value vs Timestamp original only')
    
    plt.legend()
    
    st.pyplot(fig2)