# import packages.data_processor as dp
import streamlit as st 
import random,time,os

from ibm_watson_machine_learning.foundation_models import Model
from ibm_watson_machine_learning.foundation_models.utils.enums import ModelTypes
from ibm_watson_machine_learning.metanames import GenTextParamsMetaNames as GenParams
from ibm_watson_machine_learning.foundation_models.utils.enums import DecodingMethods



# IBM WatsonX
model_id = ModelTypes.FLAN_UL2


credentials = {
    "url": "https://us-south.ml.cloud.ibm.com",
    "apikey": os.getenv("API_KEY")
}

project_id = os.getenv("PROJECT_ID")


instruction = '''You are a seasoned legal assistant that excels at summarizing legal documents. Generate a brief summary of below document in a formal and instructive manner:


document: subject to your compliance with these terms niantic grants you a limited nonexclusive nontransferable non sublicensable license to download and install a copy of the app on a mobile device and to run such copy of the app solely for your own personal noncommercial purposes. except as expressly permitted in these terms you may not a copy modify or create derivative works based on the app b distribute transfer sublicense lease lend or rent the app to any third party c reverse engineer decompile or disassemble the app or d make the functionality of the app available to multiple users through any means. niantic reserves all rights in and to the app not expressly granted to you under these terms. if you accessed or downloaded the app from the apple store then you agree to use the app only a on an apple branded product or device that runs ios apple s proprietary operating system software and b as permitted by the usage rules set forth in the apple store terms of service. if you accessed or downloaded the app from any app store or distribution platform like the apple store google play or amazon appstore each an app provider then you acknowledge and agree that these terms are concluded between you and niantic and not with app provider and that as between us and the app provider niantic is solely responsible for the app. app provider has no obligation to furnish any maintenance and support services with respect to the app. in the event of any failure of the app to conform to any applicable warranty you may notify app provider and app provider will refund the purchase price for the app to you if applicable and to the maximum extent permitted by applicable law app provider will have no other warranty obligation whatsoever with respect to the app. any other claims losses liabilities damages costs or expenses attributable to any failure of an app to conform to any warranty will be the sole responsibility of niantic. app provider is not responsible for addressing any claims you have or any claims of any third party relating to the app or your possession and use of the app including but not limited to i product liability claims ii any claim that the app fails to conform to any applicable legal or regulatory requirement and iii claims arising under consumer protection or similar legislation. in the event of any third party claim that the app or your possession and use of the app infringes that third party s intellectual property rights niantic will be solely responsible for the investigation defense settlement and discharge of any such intellectual property infringement claim to the extent required by these terms. app provider and its subsidiaries are third party beneficiaries of these terms as related to your license of the app and that upon your acceptance of the terms and conditions of these terms app provider will have the right and will be deemed to have accepted the right to enforce these terms as related to your license of the app against you as a third party beneficiary thereof. you must also comply with all applicable third party terms of service when using the app. you agree to comply with all u s and foreign export laws and regulations to ensure that neither the app nor any technical data related thereto nor any direct product thereof is exported or re exported directly or indirectly in violation of or used for any purposes prohibited by such laws and regulations. by using the app you represent and warrant that i you are not located in a country that is subject to a u s government embargo or that has been designated by the u s government as a terrorist supporting country and ii you are not listed on any u s government list of prohibited or restricted parties.

summary: don t copy modify resell distribute or reverse engineer this app.


document: any feedback you provide at this site shall be deemed to be non confidential. apple shall be free to use such information on an unrestricted basis.

summary: apple may use your feedback without restrictions e g. share it publicly.


document: except as required by applicable non u s local or national law the laws of the state of california excluding its conflicts of law rules govern these terms and your use of the services.

summary: the court of law governing the terms is in the state of california.


document: thanks for using dropbox. these terms of service terms cover your use and access to the services client software and websites services provided by dropbox inc our privacy policy explains how we collect and use your information while our acceptable use policy outlines your responsibilities when using our services. by using our services you re agreeing to be bound by these terms and to review our privacy and acceptable use policies. if you re using our services for an organization you re agreeing to these terms on behalf of that organization.

summary: by accepting these terms you also agree to the privacy and acceptable use policies linked in the right.


document: we may update this privacy policy to reflect changes to our information practices. if we make any change in how we use your personal information we will notify you by email sent to the e mail address specified in your account. we encourage you to periodically review this page for the latest information on our privacy practices.

summary: users should revisit the terms periodically although in case of material changes the service will notify.


document: jetbrains reserves the exclusive right to revoke authorization to view download and print site content at any time and you shall discontinue such use immediately upon notice from jetbrains.

summary: the service can delete your account without prior notice and without a reason.


document: should any part of these terms and conditions be rendered or declared invalid by an appropriate authority such invalidation of such part or portion of these terms and conditions should not invalidate the remaining portions thereof and they shall remain in full force and effect.

summary: invalidity of any portion of the terms of service does not entail invalidity of its remainder.


document: sharing with third parties we share information with third parties that help us operate provide improve integrate customize support and market our services. service providers we work with third party service providers to provide website and application development hosting maintenance backup storage virtual infrastructure payment processing analysis and other services for us which may require them to access or use information about you. if a service provider needs to access information about you to perform services on our behalf they do so under instruction from us including abiding by policies and procedures designed to protect your information. trello partners we work with third parties who provide consulting sales support and technical services to deliver and implement customer solutions around the services including the atlassian global partner network 7 we may share your information with these third parties in connection with their services such as to assist with billing and collections to provide localized support and to provide customizations. we may also share information with these third parties where you have agreed to that sharing like when you agree to us sharing your information with a trello expert for support related questions. third party apps you your administrator or other service users may choose to add new functionality or change the behavior of the services by enabling third party apps like power ups within the services. doing so may give third party apps access to your account and information about you like your name and email address and any content you choose to use in connection with those apps. if you are an administrator or contact listed on an account we share your details with the third party app provider upon installation. third party app policies and procedures are not controlled by us and this privacy policy does not cover how third party apps use your information. we encourage you to review the privacy policies of third parties before connecting to or using their applications or services to learn more about their privacy and information handling practices. if you object to information about you being shared with these third parties please disable the app. links to third party sites the services may include links that direct you to other websites or services whose privacy practices may differ from ours. your use of and any information you submit to any of those third party sites is governed by their privacy policies not this one. third party widgets some of our services contain widgets and social media features such as the twitter tweet button. these widgets and features collect your ip address which page you are visiting on the services and may set a cookie to enable the feature to function properly. widgets and social media features are either hosted by a third party or hosted directly on our services. your interactions with these features are governed by the privacy policy of the company providing it. with your consent we share information about you with third parties when you give us consent to do so. for example we often display personal testimonials of satisfied customers on our public websites. with your consent we may post your name alongside the testimonial. compliance with enforcement requests and applicable laws. enforcement of our rights in exceptional circumstances we may share information about you with a third party if we believe that sharing is reasonably necessary to a comply with any applicable law regulation legal process or governmental request including to meet national security requirements b enforce our agreements policies and terms of service c protect the security or integrity of our products and services d protect trello our customers or the public from harm or illegal activities or e respond to an emergency which we believe in good faith requires us to disclose information to assist in preventing the death or serious bodily injury of any person. for more information on how we respond to government requests see our guidelines for law enforcement8 and our transparency report 9.

summary: third parties may be involved in operating the service.


document: you also agree to register one account only for your use of the site. the site administrators reserve the right to ban users because of accessing the site with more than one account. the information we obtain through your use of this site including your registration data is subject to our privacy policy which is specifically incorporated by reference into these terms of use.

summary: service does not allow alternative accounts.


document: personal data that you transmit are never disclosed or sold by qwant to third parties except for job applications that may be shared with recruiting partners unless you ask us not to.

summary: this service does not sell your personal data.


document: please note that this privacy policy may change from time to time. we will not reduce your rights under this policy without your explicit consent and we expect most such changes will be minor. regardless we will post any policy changes on this page. we may amend this privacy policy at any time by posting the amend terms on the site. all amended terms shall automatically be effective thirty 30 days after they are initially posted on the site. each version of this policy will be identified at the top of the page by its effective date.

summary: they can change the terms of service any time they see fit even without notification to the user. your use of the service supposedly constitutes acceptance of the changes in the terms.


document: '''


parameters = {
    GenParams.MAX_NEW_TOKENS: 100, 
    GenParams.MIN_NEW_TOKENS: 10,
    GenParams.DECODING_METHOD: DecodingMethods.GREEDY,
    GenParams.REPETITION_PENALTY:2,
    GenParams.STOP_SEQUENCES: ["^a-zA-Z\d\s,.", "human", "ai"]
    
}

model = Model(
    model_id=model_id,
    params=parameters,  
    credentials=credentials,
    project_id=project_id
)



### MAIN FUNCTION ###
def main(title = "LegaWeaver"):
    st.markdown("<h1 style='text-align: center; font-size: 50px; color: #0530AD;'>{}</h1>".format(title), 
    unsafe_allow_html=True)
  
    
    text_message = st.text_area("Input your legal document here !")
    if st.button("Summarize"):

        info =model.generate_text(prompt=" ".join([instruction, text_message, "\n\nsummary: "]))

       
        st.success('Summary: {}'.format(info))

if __name__ == "__main__":
    main()