import requests
import tensorflow as tf
from tensorflow import keras
from keras.models import Sequential, load_model
from tensorflow.keras.models import Sequential
from tensorflow.keras.layers import Activation, Dense, BatchNormalization, Conv2D, MaxPool2D, Dropout, Flatten
from tensorflow.keras.optimizers import Adam
from tensorflow.keras.metrics import categorical_crossentropy
from tensorflow.keras.preprocessing.image import ImageDataGenerator, load_img, array_to_img, img_to_array
from tensorflow.keras import datasets, layers, models

import pandas as pd
import numpy as np

import gradio as gr

load_file = 'densenet256x256_weighted_tuned.hdf5'
model=load_model(load_file)


img_resize = keras.Sequential(
    [
        layers.experimental.preprocessing.Resizing(256, 256, interpolation='bilinear')
    ]
)

def classify_image(inp):
    inp = img_resize(inp)
    img_array = keras.preprocessing.image.img_to_array(inp)
    img_array = tf.expand_dims(img_array, 0)

    prediction = model.predict(img_array).flatten()
    return {'Probability of Diabetic Retinopathy:': float(np.exp(prediction)/(1+np.exp(prediction)))} #{labels[i]: float(prediction[i]) for i in range(1)}

content_image_input = gr.inputs.Image(label="Content Image")
style_image_input = gr.inputs.Image(shape=(256, 256), label="Style Image")

image = gr.inputs.Image(label = 'Image')
label = gr.outputs.Label(num_top_classes=1)

explanation = 'Page 1 examples both have DR and the model confidently predicts it correctly. Page 2 images are examples without DR and the model confidently predicts correctly. Page 3 are the type of images the model predicts poorly on. The first image on Page 3 has DR, but the model guesses incorrectly. The 2nd image on Page 3 does not have DR, but the model guesses incorrectly.'

gr.Interface(
    fn=classify_image,
    inputs= image,
    title = 'Prediction of Diabetic Retinopathy (DR)', 
    examples_per_page = 2,
    examples = ['DR100.jpeg', 'DR95.jpeg', 'Norm5.jpeg', 'Norm16.jpeg', 'DR8.jpeg', 'Norm95.jpeg' ],
    description = 'Demo for predicting the probability of having Diabetic Retinopathy with DenseNet Model.',
    article = explanation,
    outputs=label,
    theme = "peach"
).launch()