import gradio as gr

from happytransformer import HappyGeneration

happy_gen = HappyGeneration("GPT2", "DarwinAnim8or/GPT-Greentext-1.5b")

from happytransformer import GENSettings

def generate(text, length=100, penalty=3, temperature=0.8):
    args_top_k = GENSettings(no_repeat_ngram_size=penalty, do_sample=True, top_k=80, temperature=temperature, max_length=length, early_stopping=False)
    
    inputText = "Write a greentext from 4chan.org. The story should be like a bullet-point list using > as the start of each line. It must be funny and have a twist near the end.\n" 
    inputText += ">" + text + "\n>"

    print(inputText)
    
    result = happy_gen.generate_text(inputText, args=args_top_k)
    generated_text = result.text #returns generated text only

    #replace \n with actual newlines:
    generated_text = generated_text.replace('\\n', '\n')

    #clean up formatting:
    generated_text = generated_text.replace('>', '\n>')
    generated_text = generated_text.replace('\\"', "\"")

    generated_text = ">" + text + "\n>" + generated_text #include our prompt in our response (partially)

    return generated_text

examples = [
    ["be me"],
    ["be going to heaven"],
    #["be going to work"],
    #["be baking a pie"],
    #["come home after another tiring day"],
    ["be a plague doctor"]
]

demo = gr.Interface(
    fn=generate,
    inputs=[
        gr.inputs.Textbox(lines=5, label="Input Text"),
        gr.inputs.Slider(5, 200, label='Length', default=100, step=5),
        gr.inputs.Slider(1, 10, label='no repeat ngram size', default=2, step=1),
        gr.inputs.Slider(0.0, 1.0, label='Temperature - control randomness', default=0.6, step=0.1)
    ],
    outputs=gr.outputs.Textbox(label="Generated Text"),
    examples=examples,
    title="GPT-Greentext Playground",
    description="Using the 1.5b size model. You may need to run it a few times in order to get something good!"
)

demo.launch()