import gradio as gr
from transformers import BlipProcessor, BlipForConditionalGeneration

model_id = "dblasko/blip-dalle3-img2prompt"
model = BlipForConditionalGeneration.from_pretrained(model_id)
processor = BlipProcessor.from_pretrained(model_id)

def generate_caption(image):
  inputs = processor(images=image, return_tensors="pt")
  pixel_values = inputs.pixel_values

  generated_ids = model.generate(pixel_values=pixel_values, max_length=50)
  generated_caption = processor.batch_decode(generated_ids, skip_special_tokens=True, temperature=0.8, top_k=40, top_p=0.9)[0]

  return generated_caption

# Create a gradio interface with an image input and a textbox output
demo = gr.Interface(fn=generate_caption, inputs=gr.Image(shape=(224, 224)), outputs=gr.Textbox(label="Generated caption"))
demo.launch()