#python3
#build a text summarizer using hugging face and gradio

import gradio as gr
import pandas as pd
import numpy as np
from transformers import pipeline

def summarize(text):
    summarizer = pipeline("summarization")
    return summarizer(text, max_length=512, min_length=30)[0]['summary_text']

gr.Interface(fn=summarize, inputs=gr.inputs.Textbox(lines=7, placeholder="Enter text here"), outputs="text").launch(inline = False)