import gradio as gr
from fastai.vision.all import *
import pathlib
plt = platform.system()
if plt == 'Linux': pathlib.WindowsPath = pathlib.PosixPath

def is_cat(x): return x[0].isupper()


learn = load_learner("model1.pk1")

category = ('dog', 'cat')

def classify_image(img):
    pred,pred_idx,probs = learn.predict(img)
    return dict(zip(category, map(float, probs)))
    
image = gr.inputs.Image(shape=(224,224))
label = gr.outputs.Label(num_top_classes=2)
examples = ['dog.jpg']

gr.Interface(fn=classify_image, inputs=image, outputs=label, examples=examples, title='Cat vs Dog', description='A simple web app to classify images of cats and dogs').launch()