import gradio as gr
import os
import openai

# 请记得要把 api 的 key 放到 settings 下面的 Repository Secrets 里。
# 目前有个特别奇怪的问题： duplicate 的 key 如果和原来的 key 重名，build 就会失败。不知是否是今天正在 migrating 的原因。
# 作为 workaround，请对 key 使用一个不同的名字，并且记得修改下面这行代码中的 key 的名字。
openai.api_key = os.getenv("key4")




    
# 如果你只打算通过 prompt 来定制机器人的行为，只需要修改这段 prompt 就够了。
prompt = '你现在是一个MBTI测试助理，现在我要开始MBTI测试。你要通过5个问题来测试我的mbti人格类型，每个问题要有abcd四个选项。5个问题内容必须是不同的方面。而且每个问题的选项都和其他问题的选项不同。等我直接回复这六个问题我的答案之后，你帮我给出人格类型分析结果，并对这个结果的人格特征做详细描述，并且告诉我这个人格类型适合和什么类型的人做朋友，适合和什么样类型的人做情侣。注意，一次性发给我这5个问题以及问题相应的四个选项，在我回复答案后你再回复结果和描述。注意，每次回答的时候可能是我的不同朋友来做测试，你必须对每次回答你刚刚设计的问题，单独分析每次答案的人格类型，不要参考过往对话中的答案。注意，全程使用中文。在我说完第一句话后你就开始出题，然后我做答，你再回复我的人格类型。如果你理解了，我们现在就开始，'

# 修改本函数，来实现你自己的 chatbot
# p: 对机器人说话的内容  
# qid: 当前消息的唯一标识。例如 `'bxqid-cManAtRMszw...'`。由平台生成并传递给机器人，以便机器人区分单个问题（写日志、追踪调试、异步回调等）。同步调用可忽略。  
# uid: 用户的唯一标识。例如`'bxuid-Aj8Spso8Xsp...'`。由平台生成并传递给机器人，以便机器人区分用户。可被用于实现多轮对话的功能。  
# 返回值：[type, content]
# 详见 https://huggingface.co/spaces/baixing/hackathon_test/blob/main/bot-api.md
def chat(p, qid, uid):
    return ["text", callapi(p)]

def callapi(p):
    response = openai.ChatCompletion.create(
        model="gpt-3.5-turbo",
        messages= [{"role":"system", "content":prompt},
                   {"role":"user", "content":p}
                   ]
    )
    print(response)
    response = response["choices"][0]["message"]["content"]
    while response.startswith("\n"):
        response = response[1:]
    return response



iface = gr.Interface(fn=chat, 
                     inputs=["text", "text", "text"], 
                     outputs=["text", "text"],
                     description="""我是人格测试助手，在瀛海威广场的多轮对话中可以做人格测试哦~  [瀛海威广场](https://huggingface.co/spaces/baixing/hackathon_test)，需要填写的api是 https://dao3-mbti-test.hf.space/run/predict 
 """)

iface.launch()