import gradio as gr
import os
import sys
from pathlib import Path
import random
import string
import time
from queue import Queue
from threading import Thread
import emoji


text_gen=gr.Interface.load("spaces/Dao3/MagicPrompt-Stable-Diffusion")
def get_prompts(prompt_text):
    if prompt_text:
        return text_gen("dreamlikeart, " + prompt_text)
    else:
        return text_gen("")
proc1=gr.Interface.load("models/dreamlike-art/dreamlike-diffusion-1.0")

def restart_script_periodically():
    while True:
        random_time = random.randint(540, 600)
        time.sleep(random_time)
        os.execl(sys.executable, sys.executable, *sys.argv)


restart_thread = Thread(target=restart_script_periodically, daemon=True)
restart_thread.start()


queue = Queue()
queue_threshold = 100

def add_random_noise(prompt, noise_level=0.00):
    if noise_level == 0:
        noise_level = 0.00
    percentage_noise = noise_level * 5
    num_noise_chars = int(len(prompt) * (percentage_noise/100))
    noise_indices = random.sample(range(len(prompt)), num_noise_chars)
    prompt_list = list(prompt)
    noise_chars = list(string.ascii_letters + string.punctuation + ' ' + string.digits)
    noise_chars.extend(['😍', '💩', '😂', '🤔', '😊', '🤗', '😭', '🙄', '😷', '🤯', '🤫', '🥴', '😴', '🤩', '🥳', '😔', '😩', '🤪', '😇', '🤢', '😈', '👹', '👻', '🤖', '👽', '💀', '🎃', '🎅', '🎄', '🎁', '🎂', '🎉', '🎈', '🎊', '🎮', '❤️', '💔', '💕', '💖', '💗', '🐶', '🐱', '🐭', '🐹', '🦊', '🐻', '🐨', '🐯', '🦁', '🐘', '🔥', '🌧️', '🌞', '🌈', '💥', '🌴', '🌊', '🌺', '🌻', '🌸', '🎨', '🌅', '🌌', '☁️', '⛈️', '❄️', '☀️', '🌤️', '⛅️', '🌥️', '🌦️', '🌧️', '🌩️', '🌨️', '🌫️', '☔️', '🌬️', '💨', '🌪️', '🌈'])
    for index in noise_indices:
        prompt_list[index] = random.choice(noise_chars)
    return "".join(prompt_list)



def send_it1(inputs, noise_level, proc1=proc1):
    prompt_with_noise = add_random_noise(inputs, noise_level)
    while queue.qsize() >= queue_threshold:
        time.sleep(2)
    queue.put(prompt_with_noise)
    output1 = proc1(prompt_with_noise)
    return output1

def send_it2(inputs, noise_level, proc1=proc1):
    prompt_with_noise = add_random_noise(inputs, noise_level)
    while queue.qsize() >= queue_threshold:
        time.sleep(2)
    queue.put(prompt_with_noise)
    output2 = proc1(prompt_with_noise)
    return output2

#def send_it3(inputs, noise_level, proc1=proc1):
    #prompt_with_noise = add_random_noise(inputs, noise_level)
    #while queue.qsize() >= queue_threshold:
        #time.sleep(2)
    #queue.put(prompt_with_noise)
    #output3 = proc1(prompt_with_noise)
    #return output3

#def send_it4(inputs, noise_level, proc1=proc1):
    #prompt_with_noise = add_random_noise(inputs, noise_level)
    #while queue.qsize() >= queue_threshold:
        #time.sleep(2)
    #queue.put(prompt_with_noise)
    #output4 = proc1(prompt_with_noise)
    #return output4


with gr.Blocks(css='style.css') as demo:
    gr.HTML(
        """
            <div style="text-align: center; max-width: 650px; margin: 0 auto;">
              <div>
                <h1 style="font-weight: 900; font-size: 3rem; margin-bottom:20px;">
                  幻梦-1.0
                </h1>
              </div>
              <p style="margin-bottom: 10px; font-size: 96%">
               差异程度: 用数值调节两张图的差异程度。数值越大，两张图的差异越大，反之越小。
              </p>
              <p style="margin-bottom: 10px; font-size: 98%">
              ❤️ 喜欢的话，就点上面的❤️吧~❤️</a>
              </p>
              <p style="margin-bottom: 10px; font-size: 98%">
              ❤️ 推荐<a href="https://aihuman.life">AIHuman.Life</a>,发现更多AI工具和用法 ❤️</a>
              </p>
            </div>
        """
    )
    with gr.Column(elem_id="col-container"):
        with gr.Row(variant="compact"):
            input_text = gr.Textbox(
                label="Short Prompt",
                show_label=False,
                max_lines=2,
                placeholder="输入你的想象（英文词汇），然后按右边按钮。没灵感？直接按！",
            ).style(
                container=False,
            )
            see_prompts = gr.Button("✨ 咒语显现 ✨").style(full_width=False)

        
        with gr.Row(variant="compact"):
            prompt = gr.Textbox(
                label="Enter your prompt",
                show_label=False,
                max_lines=2,
                placeholder="可输入完整描述词，或者用咒语显现按钮生成",
            ).style(
                container=False,
            )
            run = gr.Button("✨幻梦显形✨").style(full_width=False)
        
        with gr.Row():
            with gr.Row():
                noise_level = gr.Slider(minimum=0.0, maximum=3, step=0.1, label="差异程度")
        with gr.Row():
            with gr.Row():
                output1=gr.Image(label="Dreamlike Diffusion 1.0",show_label=False)
                output2=gr.Image(label="Dreamlike Diffusion 1.0",show_label=False)
        

        see_prompts.click(get_prompts, inputs=[input_text], outputs=[prompt], queue=False)
        run.click(send_it1, inputs=[prompt, noise_level], outputs=[output1])
        run.click(send_it2, inputs=[prompt, noise_level], outputs=[output2])


        with gr.Row():
                gr.HTML(
    """
        <div class="footer">
        <p>  <a href="https://huggingface.co/dreamlike-art/dreamlike-diffusion-1.0">Stable Diffusion模型Dreamlike Diffusion 1.0的一个应用</a> ，本案例最初作者<a href="https://twitter.com/DavidJohnstonxx/">Phenomenon1981</a>。
</p>
</div>
        <div class="acknowledgments" style="font-size: 115%">
            <p> 
            
            另一个模型：<a href="https://huggingface.co/spaces/Dao3/DreamlikeArt-PhotoReal-2.0">幻梦成真</a> </p>
        </div>
        <div class="acknowledgments" style="font-size: 115%">
            <p> 
            安利：<a href="https://tiwenti.chat/">TiWenTi.chat</a>，ChatGPT的中文案例库，按照工具用途和角色扮演用途做了分类，欢迎去看去分享~ </p>
            </p>
        </div>
    """
)

    demo.launch(enable_queue=True, inline=True)
    block.queue(concurrency_count=100)