import gradio as gr
from diffusers import StableDiffusionPipeline
import torch

model_id = "nitrosocke/mo-di-diffusion"
local_dir = "./model/"

# Download the model from the internet and save it to local directory
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, cache_dir=local_dir)

# Load the model from the local directory on subsequent runs
#pipe = StableDiffusionPipeline.from_pretrained(local_dir, torch_dtype=torch.float16)

def generate_image(prompt):
    image = pipe(prompt).images[0]
    image.save("./magical_princess.png")
    return image

inputs = gr.inputs.Textbox(label="Enter Prompt")
outputs = gr.outputs.Image(label="Generated Image", type="pil")

title = "Midjourney-Disney"
description = None

gr.Interface(generate_image, inputs, outputs, title=title).launch()
 