# import libraries
import gradio as gr
import torch
import transformers
from transformers import pipeline

# define summarizer function
def summarizer(text):
    summarizer = pipeline("summarization")
    summary = summarizer(text, max_length=100, min_length=30, do_sample=False)
    return summary

# define input and output
inputs = gr.inputs.Textbox(lines=5, label="Enter text to summarize")
outputs = gr.outputs.Textbox(label="Summary")

# define interface
interface = gr.Interface(summarizer, inputs, outputs, live=True, capture_session=True)

# run interface
interface.launch(inline=False)