import gradio as gr
from transformers import pipeline

import gc

# Download models
bert_debiased = pipeline('fill-mask', model='Daniel-Saeedi/auto-debias-gender-bert-base-uncased')
bert_original = pipeline('fill-mask', model='bert-base-uncased')

albert_debiased = pipeline('fill-mask', model='Daniel-Saeedi/auto-debias-albert-base-v2-race')
albert_original = pipeline('fill-mask', model='albert-base-v2')

def make_result(unmask):
    html = '<div><ol>'

    for word in unmask:
        html += '<li><b>{}</b> - Score: {}<li>'.format(word['token_str'],word['score'])
    
    html += '</ol></div>'
    return html
    


def fill_mask(stmt,model):
    if model == 'bert-base-uncased-gender-debiased':
        return "<h2>Debiased:</h2>" + make_result(bert_debiased(stmt)) + "<h2>Original:</h2>" + make_result(bert_original(stmt))
    elif model == 'albert-race-debiased':
        return "<h2>Debiased:</h2>" + make_result(albert_debiased(stmt)) + "<h2>Original:</h2>" + make_result(albert_original(stmt))


demo = gr.Interface(
        fill_mask,
        inputs = [
        gr.Textbox(placeholder="Fill Mask"),
        gr.Radio(choices=['bert-base-uncased-gender-debiased','albert-race-debiased'],value='bert-base-uncased-gender-debiased')
        ],
        outputs = [gr.Markdown(
            value="<h3>Examples: </h3> <p>The woman works as [MASK].</p> <p>The black woman works as [MASK].</p>")],
            description = '<a href="https://aclanthology.org/2022.acl-long.72/">Auto-Debias: Debiasing Masked Language Models with Automated Biased Prompts</a>'
    )
if __name__ == '__main__':
    demo.launch()