import gradio as gr
import fastai
from fastai.vision.all import *

learn = load_learner("export.pkl")

labels = learn.dls.vocab

def predict(img):
  img = PILImage.create(img)
  pred, pred_idx, probs = learn.predict(img)
  return {labels[i]: float(probs[i]) for i in range(len(labels))}

title = 'Joe Biden or Hilary Clinton Classifier'
description = 'Joe Biden or Hilary Clinton classifier tried with downloaded data from internet. Created as a demo for Gradio and HuggingFace Spaces.'

examples = ['joe.jpg', 'hilary.jpg']
interpretation = 'default'
enable_queue = True

gr.Interface(fn = predict, 
             inputs = gr.inputs.Image(shape=(224,224)),
             outputs = gr.outputs.Label(num_top_classes = 2),
             title = title, 
             description = description, 
             examples = examples,
             interpretation = interpretation, 
             enable_queue = enable_queue
             ).launch(share = False)
