import gradio as gr
import fastai
from fastai.vision.all import *

learn = load_learner("export.pkl")

labels = learn.dls.vocab

def predict(img):
  img = PILImage.create(img)
  pred, pred_idx, probs = learn.predict(img)
  return {labels[i]: float(probs[i]) for i in range(len(labels))}

title = 'Animal Classifier'
description = 'Animal classifier tried with downloaded data from internet. Created as a demo for Gradio and HuggingFace Spaces.'

examples = ['c.jpeg', 'e.jpeg', 'e2.jpeg', 'e3.jpeg', 'g.jpeg', 'ec.jpeg']
interpretation = 'default'
enable_queue = True

gr.Interface(fn = predict, 
             inputs = gr.inputs.Image(shape=(224,224)),
             outputs = gr.outputs.Label(num_top_classes = 4),
             title = title, 
             description = description, 
             examples = examples,
             interpretation = interpretation, 
             enable_queue = enable_queue
             ).launch(share = False)
