import os
import gradio as gr
import openai

class OpenAIUtils:
    
    @classmethod
    def use_openai_chatgpt_base(cls, prompt):
        """
        Use OpenAI's GPT-3 model, Davinci, to generate text based on the given prompt
        """
        openai.api_key = os.getenv('OPENAI_API_KEY')
        print("prompt")
        print(prompt)

        try:
            res = openai.ChatCompletion.create(
            # res = openai.Completion.create(
                model="gpt-3.5-turbo",
                messages=[
                        {"role": "system", "content": "あなたは企業の広報担当です"},
                        # {"role": "user", "content": prompt},
                        {"role": "user", "content": f"{prompt}"},
                    ]
                )
            string = res.choices[0]['message']['content']
        except openai.error.InvalidRequestError as e:
            print(f"Error: {e}")
            return None
        return string
    @classmethod
    def use_openai_davinci_base(cls, prompt):
        """
        Use OpenAI's GPT-3 model, Davinci, to generate text based on the given prompt
        """
        openai.api_key = os.getenv('OPENAI_API_KEY')
        try:
            res = openai.Completion.create(
                model="text-davinci-003",
                prompt=prompt,
                max_tokens=1024,
                temperature=0.5
            )
            string = res.choices[0].text
        except openai.error.InvalidRequestError as e:
            print(f"Error: {e}")
            return None
        return string

class CalqOffer:
    @classmethod
    def generate_reply_mail_prompt(cls, offer):
        prompt = f"""
        {offer}に対して同調する場合と否定する場合で、同じ口調、同じ文字数で返答をいくつか提案してください。
        """
        print(prompt)
        # return OpenAIUtils.use_openai_davinci_base(prompt)
        return OpenAIUtils.use_openai_chatgpt_base(prompt)

    def post_process_mail_reply(offer_reply):
        remove_list = ["（箇条書き）"]

        for item in remove_list:
            offer_reply = offer_reply.replace(item, "")

        offer_reply = offer_reply.replace("（3つ提案して）", "（3つ）")
        return offer_reply


def greet(offer):
    offer_reply = CalqOffer.generate_reply_mail_prompt(offer)
    # print(offer_reply)
    offer_reply = CalqOffer.post_process_mail_reply(offer_reply)
    print(offer_reply)
    return offer_reply

input_offer = gr.Textbox(label="自動で返答したい文章を書いてください（例：この商品のデザインとても良かった！）")
output_offer = gr.Textbox(label="返答文章提案(最大1分ほどお待ちください)")
description="""
"""


article = """

"""

iface = gr.Interface(
    fn=greet,
    inputs=[input_offer],
    outputs=[output_offer],
    title="", 
    description=description,
    article=article

    )
iface.launch()
