import gradio as gr
import os
import sys
from pathlib import Path
import numpy as np
from PIL import Image




models = [
     {"name": "SD ComVis 1.2","url": "CompVis/stable-diffusion-v1-2"},
    {"name": "SD Comvis 1.4","url": "CompVis/stable-diffusion-v1-4"},
    {"name": "SD runawayml 1.5","url": "runwayml/stable-diffusion-v1-5"},
    {"name": "SD Stability 2.1 Unclip","url": "stabilityai/stable-diffusion-2-1-unclip"},
    {"name": "SD Dreamshaper-Anime","url": "Lykon/DreamShaper"},
    ]

current_model = models[0]

text_gen = gr.Interface.load("spaces/Avenuenw/prompt-extend") 

models2 = []
for model in models:
    model_url = f"models/{model['url']}"
    loaded_model = gr.Interface.load(model_url, live=True, preprocess=True)
    models2.append(loaded_model)


def text_it(inputs, text_gen=text_gen):
    return text_gen(inputs)


def set_model(current_model_index):
    global current_model
    current_model = models[current_model_index]
    return gr.update(value=f"{current_model['name']}")


def send_it(inputs, model_choice):
    proc = models2[model_choice]
    return proc(inputs)


with gr.Blocks (css ='main.css')  as myface:
    
    gr.HTML(" <div style='font-size: 20px; font-family:verdana; background-color:#23298f; color:#FFFFFF; border:1px solid #FFFFFF; border-radius: 10px; width:50%; height: 30px; float: left; text-align:center;'> Your Promt Here</div> <div style='font-size: 20px; font-family:verdana; background-color:#23298f; color:#FFFFFF; border:1px solid #FFFFFF; border-radius: 10px; width:50%; height: 30px; float:right;text-align: center;'> Choose model here </div> " )
    with gr.Row():
        input_text = gr.Textbox(label=" ",placeholder="1.PROMPT IDEA HERE ! ",lines=4)
        # Model selection dropdown
        model_name1 = gr.Dropdown(
        label="2 Choose model here",
        choices=[m["name"] for m in models],
        type="index",
        value=current_model["name"],
        interactive=True,
    
        
       )
    with gr.Row():
        see_prompts = gr.Button("3. GENERATE YOUR PROMT IDEA HERE!")                                                      
        run = gr.Button("4. GENERATE THE IMAGE HERE!", varant="primery")
        
 #
    with gr.Row():
        output1 = gr.Image(label="")
        output2 = gr.Image(label="")
        output3 = gr.Image(label="")
    with gr.Row():          
        magic1 = gr.Textbox(label="Generated Prompt", lines=2)
        magic2 = gr.Textbox(label="Generated Prompt", lines=2)
        magic3 = gr.Textbox(label="Generated Prompt", lines=2)
   
    model_name1.change(set_model, inputs=model_name1, outputs=[output1, output2, output3,])

    run.click(send_it, inputs=[magic1, model_name1], outputs=[output1])
    run.click(send_it, inputs=[magic2, model_name1], outputs=[output2])
    run.click(send_it, inputs=[magic3, model_name1], outputs=[output3])
   

    see_prompts.click(text_it, inputs=[input_text], outputs=[magic1])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic2])
    see_prompts.click(text_it, inputs=[input_text], outputs=[magic3])
   
title="Daylight (SD) ", 
myface.queue(concurrency_count=200)
myface.launch(inline=True, max_threads=400)