import glob
import matplotlib.pyplot as plt
import matplotlib.image as mpimg
%matplotlib inline

images = []
for img_path in sorted(glob.glob('brain.png'), reverse=True):
    images.append(mpimg.imread(img_path))

images = images[:15] 

plt.figure(figsize=(20,10))

columns = 5
for i, image in enumerate(images):
    ax = plt.subplot(len(images) / columns + 1, columns, i + 1)
    ax.axes.xaxis.set_visible(False)
    ax.axes.yaxis.set_visible(False)
    ax.axis('off')
    plt.imshow(image)
    gc.collect()

