import ast
import requests

#Using Gradio Demos as API - This is Hot!
API_URL_INITIAL = "https://ysharma-playground-ai-exploration.hf.space/run/initial_dataframe"
API_URL_NEXT10 = "https://ysharma-playground-ai-exploration.hf.space/run/next_10_rows"

#define inference function
#First: Get initial images for the grid display 
def get_initial_images():
  response = requests.post(API_URL_INITIAL, json={
            "data": []
            }).json()
  #data = response["data"][0]['data'][0][0][:-1]
  response_dict = response['data'][0]
  return response_dict  #, [resp[0][:-1] for resp in response["data"][0]["data"]]

#Second: Process response dictionary to get imges as hyperlinked image tags
def process_response(response_dict):
  return [resp[0][:-1] for resp in response_dict["data"]]

response_dict = get_initial_images()
initial = process_response(response_dict)
initial_imgs  = '<div style="display: grid; grid-template-columns: repeat(3, 1fr); grid-template-rows: repeat(3, 1fr); grid-gap: 0; background-color: #fff; padding: 20px; box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);">\n' + "\n".join(initial[:-1])

#Third: Load more images for the grid
def get_next10_images(response_dict, row_count):
    row_count = int(row_count)
    #print("(1)",type(response_dict))
    #Convert the string to a dictionary
    if isinstance(response_dict, dict) == False :
        response_dict = ast.literal_eval(response_dict)
    response = requests.post(API_URL_NEXT10, json={
              "data": [response_dict, row_count ] #len(initial)-1
               }).json()
    row_count+=10
    response_dict = response['data'][0]
    #print("(2)",type(response))
    #print("(3)",type(response['data'][0]))
    next_set  = [resp[0][:-1] for resp in response_dict["data"]]
    next_set_images = '<div style="display: grid; grid-template-columns: repeat(3, 1fr); grid-template-rows: repeat(3, 1fr); grid-gap: 0; background-color: #fff; padding: 20px; box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2); ">\n' + "\n".join(next_set[:-1])
    return response_dict, row_count, next_set_images  #response['data'][0]

#get_next10_images(response_dict=response_dict, row_count=9)
#position: fixed; top: 0; left: 0; width: 100%; background-color: #fff; padding: 20px; box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

#Defining the Blocks layout
with gr.Blocks(css = """#img_search img {width: 100%; height: 100%; object-fit: cover;}""") as demo:
  gr.HTML(value="top of page", elem_id="top",visible=False)
  gr.HTML("""<div style="text-align: center; max-width: 700px; margin: 0 auto;">
        <div
        style="
            display: inline-flex;
            align-items: center;
            gap: 0.8rem;
            font-size: 1.75rem;
        "
        >
        <h1 style="font-weight: 900; margin-bottom: 7px; margin-top: 5px;">
            Using Gradio Demos as API - 2 </h1><br></div>
        <div><h4 style="font-weight: 500; margin-bottom: 7px; margin-top: 5px;">
            Stream <a href="https://github.com/playgroundai/liked_images" target="_blank">PlaygroundAI Images</a> ina beautiful grid</h4><br>
        </div>""")
  with gr.Accordion(label="Details about the working:", open=False, elem_id='accordion'):
    gr.HTML("""
        <p style="margin-bottom: 10px; font-size: 90%"><br>
        ▶️Do you see the "view api" link located in the footer of this application? 
        By clicking on this link, a page will open which provides documentation on the REST API that developers can use to query the Interface function / Block events.<br>
        ▶️In this demo, I am making such an API request to the <a href="https://huggingface.co/spaces/ysharma/Playground_AI_Exploration" target="_blank">Playground_AI_Exploration</a> Space.<br>
        ▶️I am exposing an API endpoint of this Gradio app as well. This can easily be done by one line of code, just set the api_name parameter of the event listener.
        </p></div>""")

  with gr.Column(): #(elem_id = "col-container"):
    b1 = gr.Button("Load More Images").style(full_width=False)
    df = gr.Textbox(visible=False,elem_id='dataframe', value=response_dict)
    row_count = gr.Number(visible=False, value=19 )
    img_search = gr.HTML(label = 'Images from PlaygroundAI dataset', elem_id="img_search", 
                         value=initial_imgs ) #initial[:-1] )
      
  gr.HTML('''<center><a href="https://huggingface.co/spaces/ysharma/Stream_PlaygroundAI_Images?duplicate=true"><img src="https://bit.ly/3gLdBN6" alt="Duplicate Space"></a></center> 
        </p></div>''')
  b1.click(get_next10_images, [df, row_count], [df, row_count, img_search], api_name = "load_playgroundai_images" ) 