import gradio as gr
import torch
import numpy as np
import modin.pandas as pd
from PIL import Image
from diffusers import DiffusionPipeline, StableDiffusionLatentUpscalePipeline

device = "cuda" if torch.cuda.is_available() else "cpu"
pipe = DiffusionPipeline.from_pretrained("models/stablediffusionapi/juggernaut-xl-v5", torch_dtype=torch.float16, safety_checker=None, use_safetensors=False)
upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained("stabilityai/sd-x2-latent-upscaler", torch_dtype=torch.float16)
upscaler = upscaler.to(device)
pipe = pipe.to(device)

def genie (Prompt, negative_prompt, height, width, scale, steps, seed, upscale, upscale_prompt, upscale_neg, upscale_scale, upscale_steps):
    generator = torch.Generator(device=device).manual_seed(seed)
    if upscale == "Yes":
        low_res_latents = pipe(Prompt, negative_prompt=negative_prompt, height=height, width=width, num_inference_steps=steps, guidance_scale=scale, generator=generator, output_type="latent").images
        image = upscaler(prompt=upscale_prompt, negative_prompt=upscale_neg, image=low_res_latents, num_inference_steps=upscale_steps, guidance_scale=upscale_scale, generator=generator).images[0]
    else:
        image = pipe(Prompt, negative_prompt=negative_prompt, height=height, width=width, num_inference_steps=steps, guidance_scale=scale, generator=generator).images[0]
    return image
    
gr.Interface(theme='ParityError/Anime', fn=genie, inputs=[gr.Textbox(label='Input field right under here(Prompt)'), 
                               gr.Textbox(label='What You dont want (Negative Prompt)'),
                               gr.Slider(512, 1024, 768, step=128, label='Height'),
                               gr.Slider(512, 1024, 768, step=128, label='Width'),
                               gr.Slider(1, maximum=15, value=10, step=.25), 
                               gr.Slider(25, maximum=100, value=50, step=25), 
                               gr.Slider(minimum=1, step=1, maximum=9999999999999999, randomize=True), 
                              # gr.Radio(["Yes", "No"], label='Upscale?'),
                               #gr.Textbox(label='Upscaler Prompt: Optional'),
                               #gr.Textbox(label='Upscaler Negative Prompt: Both Optional And Experimental'),
                               #gr.Slider(minimum=0, maximum=15, value=0, step=1, label='Upscale Guidance Scale'),
                               #gr.Slider(minimum=5, maximum=25, value=5, step=5, label='Upscaler Iterations')
             
                              ],
             outputs=gr.Image(label='Generated Image'), 
             title="Dream Art (SD) ", 
             description="<br> <h4> <div style='width:100%'> Info:Dream Art (SD) <br> This App is our favorite now and shows how Stable diffusion works i a good way !</h4> </div>", 
             ).launch(debug=True, max_threads=True)
