import numpy as np
import gradio as gr
import ast
import requests

from theme_dropdown import create_theme_dropdown  # noqa: F401

dropdown, js = create_theme_dropdown()

models = [
    {"name": "Stable Diffusion 2", "url": "stabilityai/stable-diffusion-2-1"},
    {"name": "stability AI", "url": "stabilityai/stable-diffusion-2-1-base"},
    {"name": "Compressed-S-D", "url": "nota-ai/bk-sdm-small"},
    {"name": "Future Diffusion", "url": "nitrosocke/Future-Diffusion"},
    {"name": "JWST Deep Space Diffusion", "url": "dallinmackay/JWST-Deep-Space-diffusion"},
    {"name": "Robo Diffusion 3 Base", "url": "nousr/robo-diffusion-2-base"},
    {"name": "Robo Diffusion", "url": "nousr/robo-diffusion"},
    {"name": "Tron Legacy Diffusion", "url": "dallinmackay/Tron-Legacy-diffusion"},
]   

text_gen = gr.Interface.load("spaces/daspartho/prompt-extend")

current_model = models[0]

models2 = []
for model in models:
    model_url = f"models/{model['url']}"
    loaded_model = gr.Interface.load(model_url, live=True, preprocess=True)
    models2.append(loaded_model)

def text_it(inputs, text_gen=text_gen):
    return text_gen(inputs)

def flip_text(x):
    return x[::-1]

def send_it(inputs, model_choice):
    proc = models2[model_choice]
    return proc(inputs)


def flip_image(x):
    return np.fliplr(x)


def set_model(current_model_index):
    global current_model
    current_model = models[current_model_index]
    return gr.update(value=f"{current_model['name']}")


with gr.Blocks(theme='pikto/theme@>=0.0.1,<0.0.3') as pan:
    gr.Markdown("AI CONTENT TOOLS.")
                    
    with gr.Tab("T-to-I"):
        
    ##model = ("stabilityai/stable-diffusion-2-1")
         model_name1 = gr.Dropdown(
                label="Choose Model",
                choices=[m["name"] for m in models],
                type="index",
                value=current_model["name"],
                interactive=True,
         )
         input_text = gr.Textbox(label="Prompt idea",)

        ##  run = gr.Button("Generate Images")
         with gr.Row():
             see_prompts = gr.Button("Generate Prompts")
             run = gr.Button("Generate Images", variant="primary")
        
         with gr.Row():
             magic1 = gr.Textbox(label="Generated Prompt", lines=2)
             output1 = gr.Image(label="")
          
             
         with gr.Row():    
             magic2 = gr.Textbox(label="Generated Prompt", lines=2)
             output2 = gr.Image(label="")

            
         run.click(send_it, inputs=[magic1, model_name1], outputs=[output1])
         run.click(send_it, inputs=[magic2, model_name1], outputs=[output2])
         see_prompts.click(text_it, inputs=[input_text], outputs=[magic1])
         see_prompts.click(text_it, inputs=[input_text], outputs=[magic2])
        
    model_name1.change(set_model, inputs=model_name1, outputs=[output1, output2,])
        
    #with gr.Tab("Flip Image"):
         #Using Gradio Demos as API - This is Hot!
           

    with gr.Tab("Diffuser"):
        with gr.Row():
            text_input = gr.Textbox()                      ##   Diffuser
            image_output = gr.Image()
        image_button = gr.Button("Flip")



   # text_button.click(flip_text, inputs=text_input, outputs=text_output)
   # image_button.click(flip_image, inputs=image_input, outputs=image_output)
pan.queue(concurrency_count=200)
pan.launch(inline=True, show_api=True, max_threads=400)
