from wordcloud import WordCloud, get_single_color_func
from stop_words import get_stop_words
import numpy as np
from PIL import Image
import matplotlib.pyplot as plt
from collections import Counter
import gradio as gr

    
def create_wc(text, lang, custom_sw, input_img, color_rgb):
    STOPWORDS = set(get_stop_words(lang))
    STOPWORDS.update(custom_sw.replace(" ", "").split(","))
    words = text.lower().split(" ")
    words = [word for word in words if word not in STOPWORDS]
    mask = np.array(input_img)
    text_dict = Counter(words)
    wordcloud = WordCloud(background_color="rgba(0, 0, 0, 0)", mode="RGBA",mask=mask, width=1000, height=1500, stopwords=STOPWORDS).generate_from_frequencies(text_dict)
    # wordcloud.recolor(colormap=colormap)
    wordcloud.recolor(color_func=get_single_color_func(f'rgb({color_rgb})'))

    return wordcloud

text_example = """
Harry Potter is a series of seven fantasy novels written by British author J. K. Rowling. The novels chronicle the lives of a young wizard, Harry Potter, and his friends Hermione Granger and Ron Weasley, all of whom are students at Hogwarts School of Witchcraft and Wizardry. The main story arc concerns Harry's struggle against Lord Voldemort, a dark wizard who intends to become immortal, overthrow the wizard governing body known as the Ministry of Magic and subjugate all wizards and Muggles (non-magical people).
The series was originally published in English by Bloomsbury in the United Kingdom and Scholastic Press in the United States. All versions around the world are printed by Grafica Veneta in Italy.[1] A series of many genres, including fantasy, drama, coming of age, and the British school story (which includes elements of mystery, thriller, adventure, horror, and romance), the world of Harry Potter explores numerous themes and includes many cultural meanings and references.[2] According to Rowling, the main theme is death.[3] Other major themes in the series include prejudice, corruption, and madness.[4]
Since the release of the first novel, Harry Potter and the Philosopher's Stone, on 26 June 1997, the books have found immense popularity, positive reviews, and commercial success worldwide. They have attracted a wide adult audience as well as younger readers and are often considered cornerstones of modern young adult literature.[5] As of February 2018, the books have sold more than 500 million copies worldwide, making them the best-selling book series in history, and have been translated into eighty languages.[6] The last four books consecutively set records as the fastest-selling books in history, with the final instalment selling roughly 2.7 million copies in the United Kingdom and 8.3 million copies in the United States within twenty-four hours of its release.
The original seven books were adapted into an eight-part namesake film series by Warner Bros. Pictures. In 2016, the total value of the Harry Potter franchise was estimated at $25 billion,[7] making Harry Potter one of the highest-grossing media franchises of all time. Harry Potter and the Cursed Child is a play based on a story co-written by Rowling.
The success of the books and films has allowed the Harry Potter franchise to expand with numerous derivative works, a travelling exhibition that premiered in Chicago in 2009, a studio tour in London that opened in 2012, a digital platform on which J. K. Rowling updates the series with new information and insight, and a pentalogy of spin-off films premiering in November 2016 with Fantastic Beasts and Where to Find Them, among many other developments. Themed attractions, collectively known as The Wizarding World of Harry Potter, have been built at several Universal Parks & Resorts amusement parks around the world.
"""

iface = gr.Interface(create_wc, 
                     ["text", gr.inputs.Dropdown(["en", "es"]) ,"text", "image", "text"], 
                     "pil",
                      examples = [[text_example, "en", "harry, potter", "glasses.png", "128,0,0"]],
                      title="Wordcloud",
                      description="Create a wordcloud from a text. Use the custom sw field to input custom stopwords separated by comma")

iface.launch()
