import matplotlib.pyplot as plt
import gradio as gr


def isprime(x):
    if x < 2:
        return False
    for i in range(2, x):
        if x % i == 0:
            return False
    return True


def ulamspiral(n):
    x = 0
    y = 0
    estado = 0 
    numsteps = 1
    cambio_dir = 0
    last_x = 0
    last_y = 0
    plt.figure(facecolor=(0, 0, 0), figsize=(20,20))
    plt.axis('off')
    for step in range(1, n+1):
        if isprime(step):
            plt.plot(x, y, "wo", markersize=8)
        if step != 1:
            plt.plot([last_x, x], [last_y, y], "w-", markersize=2)
        last_x = x
        last_y = y
        if estado == 4:
            estado = 0
        if estado == 0:
            x += 1
        elif estado == 1:
            y += 1
        elif estado == 2:
            x -= 1
        elif estado == 3:
            y -= 1
        
        if step % numsteps == 0:
            estado = (estado + 1) % 4
            cambio_dir += 1
            if cambio_dir % 2 == 0:
                numsteps += 1

    return plt.gcf()
    
iface = gr.Interface(ulamspiral, gr.inputs.Slider(1, 10000, 1), "plot")

iface.launch()