import numpy as np
import gradio as gr

def quantize(val, factor):
    quantized = (np.round(factor * np.array(val / 255)) * (255 / factor)).astype(int)
    return quantized


def fsd(factor, input_img):
    img_arr = np.asarray(input_img)
    new_img = np.copy(img_arr)

    for y in range(img_arr.shape[1] - 1):
        for x in range(img_arr.shape[0] - 1):
            old_pixel = new_img[x, y].copy()
            new_pixel = quantize(old_pixel, factor)
            new_img[x, y] = new_pixel

            quant_error = old_pixel - new_pixel
            new_img[x + 1][y    ] = new_img[x + 1][y    ] + quant_error * 7 / 16
            new_img[x - 1][y + 1] = new_img[x - 1][y + 1] + quant_error * 3 / 16
            new_img[x    ][y + 1] = new_img[x    ][y + 1] + quant_error * 5 / 16
            new_img[x + 1][y + 1] = new_img[x + 1][y + 1] + quant_error * 1 / 16
    return new_img


iface = gr.Interface(fsd, 
                    [gr.inputs.Slider(1, 10, 1), 
                    "image"], 
                    "pil",
                    title="Floyd Steinberg dithering",
                    description="Floyd Steinberg dithering algorithm")

iface.launch()