console.log("hello from poseEditor.js")
var canvas = null;
var ctx = null;

// candidateの形式：[[x1, y1, score1], [x2, y2, score2], ...]
let candidateSource = [
    [235, 158, 0.93167633],
    [234, 220, 0.97106987],
    [193, 222, 0.93366587],
    [138, 263, 0.87655306],
    [89, 308, 0.8868227],
    [276, 220, 0.9038924],
    [325, 264, 0.92930061],
    [375, 309, 0.9217211],
    [207, 347, 0.86410147],
    [203, 433, 0.86538297],
    [199, 523, 0.95236528],
    [261, 347, 0.88489777],
    [262, 430, 0.90848708],
    [261, 522, 0.94749999],
    [227, 148, 0.94189668],
    [245, 148, 0.93967074],
    [208, 158, 0.92053992],
    [258, 154, 0.73533273]
];

// subsetの形式：[[index1, index2, ..., -1], [index1, index2, ..., -1], ...]
let subset = [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 33.81122635, 18]];

// const candidateSource = [[618.00, 0.00], [618.00, 44.00], [304.00, 81.00], [482.00, 96.00], [66.00, 270.00], [171.00, 280.00], [618.00, 82.00], [307.00, 112.00], [460.00, 143.00], [0.00, 301.00], [65.00, 301.00], [172.00, 303.00], [584.00, 86.00], [275.00, 119.00], [420.00, 139.00], [0.00, 301.00], [41.00, 301.00], [144.00, 303.00], [544.00, 131.00], [348.00, 139.00], [262.00, 160.00], [0.00, 337.00], [52.00, 339.00], [130.00, 348.00], [570.00, 175.00], [283.00, 177.00], [78.00, 338.00], [172.00, 380.00], [651.00, 78.00], [338.00, 111.00], [505.00, 144.00], [92.00, 301.00], [198.00, 305.00], [661.00, 132.00], [349.00, 156.00], [541.00, 179.00], [106.00, 336.00], [203.00, 348.00], [305.00, 159.00], [665.00, 160.00], [563.00, 192.00], [80.00, 343.00], [181.00, 385.00], [614.00, 205.00], [291.00, 220.00], [432.00, 320.00], [152.00, 372.00], [43.00, 380.00], [0.00, 386.00], [623.00, 281.00], [306.00, 290.00], [92.00, 357.00], [509.00, 434.00], [304.00, 357.00], [622.00, 368.00], [47.00, 394.00], [0.00, 395.00], [142.00, 405.00], [535.00, 565.00], [655.00, 200.00], [337.00, 217.00], [467.00, 322.00], [191.00, 372.00], [83.00, 375.00], [344.00, 282.00], [655.00, 282.00], [103.00, 343.00], [237.00, 368.00], [22.00, 377.00], [0.00, 379.00], [460.00, 459.00], [305.00, 352.00], [638.00, 355.00], [0.00, 401.00], [110.00, 412.00], [411.00, 570.00], [608.00, 0.00], [608.00, 40.00], [297.00, 75.00], [469.00, 84.00], [0.00, 261.00], [58.00, 263.00], [165.00, 275.00], [625.00, 0.00], [625.00, 39.00], [309.00, 74.00], [486.00, 83.00], [71.00, 264.00], [180.00, 276.00], [599.00, 0.00], [599.00, 44.00], [284.00, 80.00], [440.00, 93.00], [48.00, 271.00], [0.00, 272.00], [157.00, 277.00], [634.00, 0.00], [633.00, 41.00], [319.00, 77.00], [79.00, 269.00], [190.00, 277.00]];
// const subset = [[1.00,6.00,12.00,18.00,24.00,28.00,33.00,39.00,43.00,49.00,54.00,59.00,65.00,72.00,77.00,84.00,90.00,97.00,32.98,18.00],[5.00,11.00,17.00,23.00,27.00,32.00,37.00,42.00,46.00,-1.00,-1.00,62.00,67.00,-1.00,82.00,88.00,95.00,100.00,25.45,15.00],[4.00,10.00,16.00,22.00,26.00,31.00,36.00,41.00,47.00,51.00,57.00,63.00,66.00,74.00,81.00,87.00,93.00,99.00,26.97,18.00],[3.00,8.00,14.00,19.00,25.00,30.00,35.00,40.00,45.00,52.00,58.00,61.00,70.00,75.00,79.00,86.00,92.00,-1.00,30.45,17.00],[2.00,7.00,13.00,20.00,-1.00,29.00,34.00,38.00,44.00,50.00,53.00,60.00,64.00,71.00,78.00,85.00,91.00,98.00,27.89,17.00],[0.00,-1.00,-1.00,-1.00,-1.00,-1.00,-1.00,-1.00,-1.00,-1.00,-1.00,-1.00,-1.00,-1.00,76.00,83.00,-1.00,96.00,3.33,4.00]];

let candidate = candidateSource.map(point => [point[0], point[1] - 70]);  


function clearCanvas() {
  var w = canvas.width;
  var h = canvas.height;
  ctx.fillStyle = 'black';
  ctx.fillRect(0, 0, w, h);
}

function resizeCanvas(width, height) {
  canvas.width = width ? width : canvas.width;
  canvas.height = height ? height : canvas.height;
  clearCanvas();
  drawBodyPose(candidate, subset);
}

function drawBodyPose(candidate, subset) {
    const stickwidth = 4;
    const limbSeq = [[2, 3], [2, 6], [3, 4], [4, 5], [6, 7], [7, 8], [2, 9], [9, 10],
                 [10, 11], [2, 12], [12, 13], [13, 14], [2, 1], [1, 15], [15, 17],
                 [1, 16], [16, 18], [3, 17], [6, 18]];
  
    const colors = [[255, 0, 0], [255, 85, 0], [255, 170, 0], [255, 255, 0], [170, 255, 0], [85, 255, 0], [0, 255, 0],
                [0, 255, 85], [0, 255, 170], [0, 255, 255], [0, 170, 255], [0, 85, 255], [0, 0, 255], [85, 0, 255],
                [170, 0, 255], [255, 0, 255], [255, 0, 170], [255, 0, 85]];
                
    for (let i = 0; i < 17; i++) {
      for (let n = 0; n < subset.length; n++) {
        const index0 = subset[n][limbSeq[i][0]-1];
        const index1 = subset[n][limbSeq[i][1]-1];
        if (index0 === -1 || index1 === -1) {
          continue;
        }
        const [X0, Y0] = candidate[index0].slice(0, 2);
        const [X1, Y1] = candidate[index1].slice(0, 2);
        ctx.beginPath();
        ctx.lineWidth=stickwidth;
        ctx.strokeStyle = `rgb(${colors[i].join(',')})`;
        ctx.moveTo(X0, Y0);
        ctx.lineTo(X1, Y1);
        ctx.stroke();
      }
    }

    ctx.font = '12px serif';
    for (let i = 0; i < 18; i++) {
      for (let n = 0; n < subset.length; n++) {
        const index = subset[n][i];
        if (index === -1) {
          continue;
        }
        const [x, y] = candidate[index].slice(0, 2);
        ctx.beginPath();
        ctx.arc(x, y, 4, 0, 2 * Math.PI);
        ctx.fillStyle = `rgb(${colors[i].join(',')})`;
        ctx.fill();
        ctx.fillStyle = 'rgb(255,255,255)'
        // ctx.fillText(index, x-3, y+4);
      }
    }
}

function getNearestCandidate(x, y) {
    let minDist = Infinity;
    let minIndex = -1;
    for (let i = 0; i < candidate.length; i++) {
      const dist = Math.sqrt((x - candidate[i][0]) ** 2 + (y - candidate[i][1]) ** 2);
      if (dist < minDist) {
        minDist = dist;
        minIndex = i;
      }
    }
    return [minIndex,minDist];
}

// ドラッグ中に座標を保持するための変数
let isDragging = false;
let dragIndex = -1;
let dragStartX = 0;
let dragStartY = 0;
let draggingCandidate = null;
let dragPersonIndex = -1;

function getCanvasPosition(event) {
  const rect = canvas.getBoundingClientRect();
  const x = event.clientX - rect.left;
  const y = event.clientY - rect.top;
  return [x, y];
}

// Canvas要素上でマウスが押された場合に呼び出される関数
function handleMouseDown(event) {
  const [x, y] = getCanvasPosition(event);
  const [index, minDist] = getNearestCandidate(x, y);

  // ドラッグ処理の開始
  if (event.altKey || event.ctrlKey || event.shiftKey || minDist < 16) {
    isDragging = true;
    dragIndex = index;
    dragStartX = x;
    dragStartY = y;
    draggingCandidate = JSON.parse(JSON.stringify(candidate))

    // indexが含まれる人間を探す
    for (let i = 0; i < subset.length; i++) {
      var found = subset[i].indexOf(index);
      if (found != -1 && found < 18) {
        dragPersonIndex = i;
        break;
      }
    }
  }
}

function forEachCandidateOfPerson(personIndex, callback) {
  if (personIndex === -1) { return; }

  for (let i = 0; i < 18; i++) {
    const index = subset[personIndex][i];
    if (index === -1) {
      continue;
    }
    callback(index);
  }
}

// Canvas要素上でマウスが動いた場合に呼び出される関数
function handleMouseMove(event) {
  if (!isDragging) {
    return;
  }

  const [x, y] = getCanvasPosition(event);

  const dragOffsetX = x - dragStartX;
  const dragOffsetY = y - dragStartY;

  if (event.ctrlKey) {
    // 拡大縮小（人間ごと）
    let xScale = 1 + dragOffsetX / canvas.width;
    let yScale = 1 + dragOffsetY / canvas.height;
    forEachCandidateOfPerson(dragPersonIndex, (index) => {
      candidate[index][0] = (draggingCandidate[index][0] - dragStartX) * xScale + dragStartX;
      candidate[index][1] = (draggingCandidate[index][1] - dragStartY) * yScale + dragStartY;
    });
  } else if (event.shiftKey) {
    // 回転（人間ごと）
    let angle = Math.atan2(dragOffsetY, dragOffsetX);
    forEachCandidateOfPerson(dragPersonIndex, (index) => {
      let x = draggingCandidate[index][0] - dragStartX;
      let y = draggingCandidate[index][1] - dragStartY;
      candidate[index][0] = x * Math.cos(angle) - y * Math.sin(angle) + dragStartX;
      candidate[index][1] = x * Math.sin(angle) + y * Math.cos(angle) + dragStartY;
    });
  } else if (event.altKey) {
    // 全体移動(人間ごと
    forEachCandidateOfPerson(dragPersonIndex, (index) => {
      candidate[index][0] = draggingCandidate[index][0] + dragOffsetX;
      candidate[index][1] = draggingCandidate[index][1] + dragOffsetY;
    });
  } else {
    // 個別移動
    candidate[dragIndex][0] = draggingCandidate[dragIndex][0] + dragOffsetX;
    candidate[dragIndex][1] = draggingCandidate[dragIndex][1] + dragOffsetY;
  }

  clearCanvas();
  drawBodyPose(candidate, subset);
}

// Canvas要素上でマウスが離された場合に呼び出される関数
function handleMouseUp(event) {
  isDragging = false;
}

function initializePose(jsonData,w,h) {
  console.log("initializePose");
  if (jsonData != null) {
    candidate = jsonData.candidate;
    subset = jsonData.subset;
  }

  canvas = document.getElementById('canvas');
  ctx = canvas.getContext('2d');

  canvas.addEventListener('mousedown', handleMouseDown);
  canvas.addEventListener('mousemove', handleMouseMove);
  canvas.addEventListener('mouseup', handleMouseUp);

  resizeCanvas(w, h);
}

function savePose() {
    const canvasUrl = canvas.toDataURL();

    const createEl = document.createElement('a');
    createEl.href = canvasUrl;

    // This is the name of our downloaded file
    createEl.download = "pose.png";

    createEl.click();
    createEl.remove();
    return { "candidate": candidate, "subset": subset };
}
