
import gradio as gr
from gradio.mix import Series

description = """
 This space mixes DReAMy's large-multilingual [emotion-classification model](https://github.com/lorenzoscottb/DReAMy) with Whisper from OpenAI, 
 to classify recordings on their emotional content accordingly to the Hall and Van de Castle framework. For more details, 
 see the [Bertolini et al., 23](https://arxiv.org/abs/2302.14828v1) pre-print.



 Disclaimer: if you run into the `503, Error: Model [model_name] is currently loading` error message, just wait and or refresh the page. 
 The indicated model still has to be loaded by the API.
"""
title       = "DReAM v. II"

whisper = gr.Interface.load("models/openai/whisper-large")

interface_model_L = gr.Interface.load("models/DReAMy-lib/xlm-roberta-large-DreamBank-emotion-presence")

Series(
    whisper, 
    interface_model_L,
    description = description,
    title = title,
    inputs = gr.Audio(source="microphone"),
).launch()
