import gradio as gr
import openai
from dotenv import load_dotenv
import os

# Load the environment variables from the .env file
load_dotenv()

# Get the API key from the environment variable
openai.api_key = os.getenv("OPENAI_API_KEY")


def predict(input):
    response = openai.ChatCompletion.create(
        model="gpt-4", messages=[{"role": "user", "content": input}]
    )
    return response.choices[0].message.content


demo = gr.Interface(fn=predict, inputs="text", outputs="text", title="GGAI LAB DEMO")

if __name__ == "__main__":
    demo.launch()
