---
title: gpt-demo
app_file: app.py
sdk: gradio
sdk_version: 3.34.0
---
# Chatbot with OpenAI API and Gradio

This is a simple chatbot application that uses the OpenAI API and Gradio library to generate responses based on user input. It allows you to have interactive conversations with the chatbot.

## Prerequisites

- Python 3.6 or higher
- Pip package manager

## Installation

```
pip install -r requirements.txt
```

## Configuration

1. Create an OpenAI account if you don't have one already: https://openai.com/
2. Obtain an API key from OpenAI.
3. Create a file named `.env` in the project directory.
4. Open the `.env` file and add the following line, replacing `YOUR_API_KEY` with your actual OpenAI API key:

```
   OPENAI_API_KEY=YOUR_API_KEY
```

## Usage

1. Run the application:

```
   python app.py
```

2. The application will start and display a URL in the terminal.
3. Open the provided URL in your web browser.
4. Enter a text input in the input area, and the chatbot will generate a response.
5. The response will be displayed in the output area of the interface.

## Customization

- To modify the behavior of the chatbot, you can edit the `predict()` function in `app.py`. This function handles the interaction with the OpenAI API and the generation of responses.

## Contributing

Contributions are welcome! If you find any issues or have suggestions for improvements, please create an issue or submit a pull request.

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.
