import gradio as gr
import tensorflow as tf
import numpy as np
from PIL import Image
import json

# Carregue o modelo previamente treinado
model = tf.keras.models.load_model("model_acc_0.7240.h5")

# Carregue o arquivo JSON com as categorias indexadas e descrições de diagnóstico
with open("categories.json", "r") as json_file:
    categories_data = json.load(json_file)

categories = [entry["category"] for entry in categories_data]
diagnoses = [entry["diagnosis"] for entry in categories_data]

# Descrição do modelo e seu objetivo em português
model_description = (
    "Este modelo foi treinado para classificar imagens médicas do trato gastrointestinal humano em várias categorias "
    "com diagnósticos associados. Ele pode ajudar a identificar condições médicas a partir de imagens."
)

# Crie uma função para realizar a classificação
def classify_image(image):
    try:
        # Redimensione a imagem para 100x100 pixels
        image = Image.fromarray(image.astype('uint8'))
        image = image.resize((100, 100))  # Redimensione para 100x100
        image = np.array(image)

        # Realize a classificação
        prediction = model.predict(image[None, ...])

        # Decodifique a classe prevista
        class_idx = np.argmax(prediction)
        class_label = categories[class_idx]
        diagnosis = diagnoses[class_idx]

        return f"Classe prevista: {class_label}\nDiagnóstico: {diagnosis}"
    except Exception as e:
        return str(e)

# Crie uma interface Gradio com descrição completa e título informativo em português
iface = gr.Interface(
    fn=classify_image,
    inputs=gr.inputs.Image(),  # Entrada de imagem
    outputs="text",  # Saída de texto com a classe prevista e diagnóstico
    title="Sistema de Classificação de Anomalias Gastrointestinais por Imagem",
    description=model_description
)

# Inicie a interface Gradio
iface.launch()
