import pandas as pd
import matplotlib.pyplot as plt
import gradio as gr

def plot_time_series(data):
    # Processar os dados da série temporal
    lines = data.strip().split("\n")
    data = [line.strip().split(",") for line in lines]
    df = pd.DataFrame(data, columns=["date", "value"])
    df["date"] = pd.to_datetime(df["date"])
    df["value"] = df["value"].astype(float)

    # Criar o gráfico de linhas da série temporal
    plt.figure(figsize=(10, 6))
    plt.plot(df["date"], df["value"])
    plt.xlabel("Data")
    plt.ylabel("Valor")
    plt.title("Série Temporal")
    plt.xticks(rotation=45)
    plt.tight_layout()
    plt.show()

# Criar a interface Gradio
iface = gr.Interface(
    fn=plot_time_series,
    inputs=gr.inputs.Textbox(label="Insira a série temporal em formato de tabela com duas colunas: 'date' e 'value'"),
    outputs=None,
    live=True,
    capture_session=True,
    title="Visualização de Série Temporal",
    description="Cole os dados da série temporal em formato de tabela com duas colunas: 'date' e 'value'. O aplicativo exibirá um gráfico de linhas da série temporal."
)

# Executar o aplicativo
iface.launch()
