import gradio as gr
from PIL import Image

# Import the ObstructionDetector class from your module
from obstruction_detector import ObstructionDetector

# Create an instance of ObstructionDetector
detector = ObstructionDetector()

# Define a Gradio function to process the image and return the report
def process_image(image):
    # Call the detect_obstruction method of the ObstructionDetector with the PIL image
    report = detector.detect_obstruction(image)
    
    return report

# Define the Gradio interface
iface = gr.Interface(fn=process_image, 
                     inputs=gr.inputs.Image(shape=(224, 224)),  # Adjust shape as needed
                     outputs="text")

# Launch the Gradio interface
iface.launch()